package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait LogType {
  def unwrap: software.amazon.awssdk.services.lambda.model.LogType
}
object LogType {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.LogType
  ): zio.aws.lambda.model.LogType = value match {
    case software.amazon.awssdk.services.lambda.model.LogType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.LogType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.lambda.model.LogType.TAIL =>
      val r = Tail
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.LogType {
    override def unwrap: software.amazon.awssdk.services.lambda.model.LogType =
      software.amazon.awssdk.services.lambda.model.LogType.UNKNOWN_TO_SDK_VERSION
  }
  case object None extends zio.aws.lambda.model.LogType {
    override def unwrap: software.amazon.awssdk.services.lambda.model.LogType =
      software.amazon.awssdk.services.lambda.model.LogType.NONE
  }
  case object Tail extends zio.aws.lambda.model.LogType {
    override def unwrap: software.amazon.awssdk.services.lambda.model.LogType =
      software.amazon.awssdk.services.lambda.model.LogType.TAIL
  }
}
