package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.DestinationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OnSuccess(destination: Option[DestinationArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.OnSuccess = {
    import OnSuccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.OnSuccess
      .builder()
      .optionallyWith(
        destination.map(value => DestinationArn.unwrap(value): java.lang.String)
      )(_.destination)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.OnSuccess.ReadOnly =
    zio.aws.lambda.model.OnSuccess.wrap(buildAwsValue())
}
object OnSuccess {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lambda.model.OnSuccess] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.OnSuccess =
      zio.aws.lambda.model.OnSuccess(destination.map(value => value))
    def destination: Option[DestinationArn]
    def getDestination: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.OnSuccess
  ) extends zio.aws.lambda.model.OnSuccess.ReadOnly {
    override val destination: Option[DestinationArn] = scala
      .Option(impl.destination())
      .map(value => zio.aws.lambda.model.primitives.DestinationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.OnSuccess
  ): zio.aws.lambda.model.OnSuccess.ReadOnly = new Wrapper(impl)
}
