package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{
  Timeout,
  CodeSigningConfigArn,
  RoleArn,
  KMSKeyArn,
  TagValue,
  MemorySize,
  LayerVersionArn,
  Description,
  FunctionName,
  Handler,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateFunctionRequest(
    functionName: FunctionName,
    runtime: Option[zio.aws.lambda.model.Runtime] = None,
    role: RoleArn,
    handler: Option[Handler] = None,
    code: zio.aws.lambda.model.FunctionCode,
    description: Option[Description] = None,
    timeout: Option[Timeout] = None,
    memorySize: Option[MemorySize] = None,
    publish: Option[Boolean] = None,
    vpcConfig: Option[zio.aws.lambda.model.VpcConfig] = None,
    packageType: Option[zio.aws.lambda.model.PackageType] = None,
    deadLetterConfig: Option[zio.aws.lambda.model.DeadLetterConfig] = None,
    environment: Option[zio.aws.lambda.model.Environment] = None,
    kmsKeyArn: Option[KMSKeyArn] = None,
    tracingConfig: Option[zio.aws.lambda.model.TracingConfig] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    layers: Option[Iterable[LayerVersionArn]] = None,
    fileSystemConfigs: Option[Iterable[zio.aws.lambda.model.FileSystemConfig]] =
      None,
    imageConfig: Option[zio.aws.lambda.model.ImageConfig] = None,
    codeSigningConfigArn: Option[CodeSigningConfigArn] = None,
    architectures: Option[Iterable[zio.aws.lambda.model.Architecture]] = None,
    ephemeralStorage: Option[zio.aws.lambda.model.EphemeralStorage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CreateFunctionRequest = {
    import CreateFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CreateFunctionRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(runtime.map(value => value.unwrap))(_.runtime)
      .role(RoleArn.unwrap(role): java.lang.String)
      .optionallyWith(
        handler.map(value => Handler.unwrap(value): java.lang.String)
      )(_.handler)
      .code(code.buildAwsValue())
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(timeout.map(value => Timeout.unwrap(value): Integer))(
        _.timeout
      )
      .optionallyWith(
        memorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.memorySize)
      .optionallyWith(publish.map(value => value: java.lang.Boolean))(_.publish)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(packageType.map(value => value.unwrap))(_.packageType)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        kmsKeyArn.map(value => KMSKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(tracingConfig.map(value => value.buildAwsValue()))(
        _.tracingConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            LayerVersionArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.layers)
      .optionallyWith(
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemConfigs)
      .optionallyWith(imageConfig.map(value => value.buildAwsValue()))(
        _.imageConfig
      )
      .optionallyWith(
        codeSigningConfigArn.map(value =>
          CodeSigningConfigArn.unwrap(value): java.lang.String
        )
      )(_.codeSigningConfigArn)
      .optionallyWith(
        architectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.architecturesWithStrings)
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.CreateFunctionRequest.ReadOnly =
    zio.aws.lambda.model.CreateFunctionRequest.wrap(buildAwsValue())
}
object CreateFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CreateFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CreateFunctionRequest =
      zio.aws.lambda.model.CreateFunctionRequest(
        functionName,
        runtime.map(value => value),
        role,
        handler.map(value => value),
        code.asEditable,
        description.map(value => value),
        timeout.map(value => value),
        memorySize.map(value => value),
        publish.map(value => value),
        vpcConfig.map(value => value.asEditable),
        packageType.map(value => value),
        deadLetterConfig.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        kmsKeyArn.map(value => value),
        tracingConfig.map(value => value.asEditable),
        tags.map(value => value),
        layers.map(value => value),
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageConfig.map(value => value.asEditable),
        codeSigningConfigArn.map(value => value),
        architectures.map(value => value),
        ephemeralStorage.map(value => value.asEditable)
      )
    def functionName: FunctionName
    def runtime: Option[zio.aws.lambda.model.Runtime]
    def role: RoleArn
    def handler: Option[Handler]
    def code: zio.aws.lambda.model.FunctionCode.ReadOnly
    def description: Option[Description]
    def timeout: Option[Timeout]
    def memorySize: Option[MemorySize]
    def publish: Option[Boolean]
    def vpcConfig: Option[zio.aws.lambda.model.VpcConfig.ReadOnly]
    def packageType: Option[zio.aws.lambda.model.PackageType]
    def deadLetterConfig: Option[zio.aws.lambda.model.DeadLetterConfig.ReadOnly]
    def environment: Option[zio.aws.lambda.model.Environment.ReadOnly]
    def kmsKeyArn: Option[KMSKeyArn]
    def tracingConfig: Option[zio.aws.lambda.model.TracingConfig.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def layers: Option[List[LayerVersionArn]]
    def fileSystemConfigs
        : Option[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]]
    def imageConfig: Option[zio.aws.lambda.model.ImageConfig.ReadOnly]
    def codeSigningConfigArn: Option[CodeSigningConfigArn]
    def architectures: Option[List[zio.aws.lambda.model.Architecture]]
    def ephemeralStorage: Option[zio.aws.lambda.model.EphemeralStorage.ReadOnly]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getRuntime: ZIO[Any, AwsError, zio.aws.lambda.model.Runtime] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(role)
    def getHandler: ZIO[Any, AwsError, Handler] =
      AwsError.unwrapOptionField("handler", handler)
    def getCode: ZIO[Any, Nothing, zio.aws.lambda.model.FunctionCode.ReadOnly] =
      ZIO.succeed(code)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTimeout: ZIO[Any, AwsError, Timeout] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("memorySize", memorySize)
    def getPublish: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publish", publish)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getPackageType: ZIO[Any, AwsError, zio.aws.lambda.model.PackageType] =
      AwsError.unwrapOptionField("packageType", packageType)
    def getDeadLetterConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DeadLetterConfig.ReadOnly] =
      AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.lambda.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
    def getKmsKeyArn: ZIO[Any, AwsError, KMSKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getTracingConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.TracingConfig.ReadOnly] =
      AwsError.unwrapOptionField("tracingConfig", tracingConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLayers: ZIO[Any, AwsError, List[LayerVersionArn]] =
      AwsError.unwrapOptionField("layers", layers)
    def getFileSystemConfigs: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.FileSystemConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemConfigs", fileSystemConfigs)
    def getImageConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.ImageConfig.ReadOnly] =
      AwsError.unwrapOptionField("imageConfig", imageConfig)
    def getCodeSigningConfigArn: ZIO[Any, AwsError, CodeSigningConfigArn] =
      AwsError.unwrapOptionField("codeSigningConfigArn", codeSigningConfigArn)
    def getArchitectures
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Architecture]] =
      AwsError.unwrapOptionField("architectures", architectures)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.lambda.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CreateFunctionRequest
  ) extends zio.aws.lambda.model.CreateFunctionRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val runtime: Option[zio.aws.lambda.model.Runtime] = scala
      .Option(impl.runtime())
      .map(value => zio.aws.lambda.model.Runtime.wrap(value))
    override val role: RoleArn =
      zio.aws.lambda.model.primitives.RoleArn(impl.role())
    override val handler: Option[Handler] = scala
      .Option(impl.handler())
      .map(value => zio.aws.lambda.model.primitives.Handler(value))
    override val code: zio.aws.lambda.model.FunctionCode.ReadOnly =
      zio.aws.lambda.model.FunctionCode.wrap(impl.code())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val timeout: Option[Timeout] = scala
      .Option(impl.timeout())
      .map(value => zio.aws.lambda.model.primitives.Timeout(value))
    override val memorySize: Option[MemorySize] = scala
      .Option(impl.memorySize())
      .map(value => zio.aws.lambda.model.primitives.MemorySize(value))
    override val publish: Option[Boolean] =
      scala.Option(impl.publish()).map(value => value: Boolean)
    override val vpcConfig: Option[zio.aws.lambda.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.lambda.model.VpcConfig.wrap(value))
    override val packageType: Option[zio.aws.lambda.model.PackageType] = scala
      .Option(impl.packageType())
      .map(value => zio.aws.lambda.model.PackageType.wrap(value))
    override val deadLetterConfig
        : Option[zio.aws.lambda.model.DeadLetterConfig.ReadOnly] = scala
      .Option(impl.deadLetterConfig())
      .map(value => zio.aws.lambda.model.DeadLetterConfig.wrap(value))
    override val environment
        : Option[zio.aws.lambda.model.Environment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.lambda.model.Environment.wrap(value))
    override val kmsKeyArn: Option[KMSKeyArn] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.lambda.model.primitives.KMSKeyArn(value))
    override val tracingConfig
        : Option[zio.aws.lambda.model.TracingConfig.ReadOnly] = scala
      .Option(impl.tracingConfig())
      .map(value => zio.aws.lambda.model.TracingConfig.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lambda.model.primitives
              .TagKey(key) -> zio.aws.lambda.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val layers: Option[List[LayerVersionArn]] = scala
      .Option(impl.layers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.LayerVersionArn(item)
        }.toList
      )
    override val fileSystemConfigs
        : Option[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]] = scala
      .Option(impl.fileSystemConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.FileSystemConfig.wrap(item)
        }.toList
      )
    override val imageConfig
        : Option[zio.aws.lambda.model.ImageConfig.ReadOnly] = scala
      .Option(impl.imageConfig())
      .map(value => zio.aws.lambda.model.ImageConfig.wrap(value))
    override val codeSigningConfigArn: Option[CodeSigningConfigArn] = scala
      .Option(impl.codeSigningConfigArn())
      .map(value => zio.aws.lambda.model.primitives.CodeSigningConfigArn(value))
    override val architectures
        : Option[List[zio.aws.lambda.model.Architecture]] = scala
      .Option(impl.architectures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.Architecture.wrap(item)
        }.toList
      )
    override val ephemeralStorage
        : Option[zio.aws.lambda.model.EphemeralStorage.ReadOnly] = scala
      .Option(impl.ephemeralStorage())
      .map(value => zio.aws.lambda.model.EphemeralStorage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CreateFunctionRequest
  ): zio.aws.lambda.model.CreateFunctionRequest.ReadOnly = new Wrapper(impl)
}
