package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.ReservedConcurrentExecutions
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetFunctionConcurrencyResponse(
    reservedConcurrentExecutions: Option[ReservedConcurrentExecutions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse = {
    import GetFunctionConcurrencyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse
      .builder()
      .optionallyWith(
        reservedConcurrentExecutions.map(value =>
          ReservedConcurrentExecutions.unwrap(value): Integer
        )
      )(_.reservedConcurrentExecutions)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly =
    zio.aws.lambda.model.GetFunctionConcurrencyResponse.wrap(buildAwsValue())
}
object GetFunctionConcurrencyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionConcurrencyResponse =
      zio.aws.lambda.model.GetFunctionConcurrencyResponse(
        reservedConcurrentExecutions.map(value => value)
      )
    def reservedConcurrentExecutions: Option[ReservedConcurrentExecutions]
    def getReservedConcurrentExecutions
        : ZIO[Any, AwsError, ReservedConcurrentExecutions] =
      AwsError.unwrapOptionField(
        "reservedConcurrentExecutions",
        reservedConcurrentExecutions
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse
  ) extends zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly {
    override val reservedConcurrentExecutions
        : Option[ReservedConcurrentExecutions] = scala
      .Option(impl.reservedConcurrentExecutions())
      .map(value =>
        zio.aws.lambda.model.primitives.ReservedConcurrentExecutions(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse
  ): zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly = new Wrapper(
    impl
  )
}
