package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait InvocationType {
  def unwrap: software.amazon.awssdk.services.lambda.model.InvocationType
}
object InvocationType {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.InvocationType
  ): zio.aws.lambda.model.InvocationType = value match {
    case software.amazon.awssdk.services.lambda.model.InvocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.InvocationType.EVENT =>
      val r = Event
      r
    case software.amazon.awssdk.services.lambda.model.InvocationType.REQUEST_RESPONSE =>
      val r = RequestResponse
      r
    case software.amazon.awssdk.services.lambda.model.InvocationType.DRY_RUN =>
      val r = DryRun
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.InvocationType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.InvocationType =
      software.amazon.awssdk.services.lambda.model.InvocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object Event extends zio.aws.lambda.model.InvocationType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.InvocationType =
      software.amazon.awssdk.services.lambda.model.InvocationType.EVENT
  }
  case object RequestResponse extends zio.aws.lambda.model.InvocationType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.InvocationType =
      software.amazon.awssdk.services.lambda.model.InvocationType.REQUEST_RESPONSE
  }
  case object DryRun extends zio.aws.lambda.model.InvocationType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.InvocationType =
      software.amazon.awssdk.services.lambda.model.InvocationType.DRY_RUN
  }
}
