package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListVersionsByFunctionResponse(
    nextMarker: Option[String] = None,
    versions: Option[Iterable[zio.aws.lambda.model.FunctionConfiguration]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse = {
    import ListVersionsByFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListVersionsByFunctionResponse.ReadOnly =
    zio.aws.lambda.model.ListVersionsByFunctionResponse.wrap(buildAwsValue())
}
object ListVersionsByFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListVersionsByFunctionResponse =
      zio.aws.lambda.model.ListVersionsByFunctionResponse(
        nextMarker.map(value => value),
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[String]
    def versions
        : Option[List[zio.aws.lambda.model.FunctionConfiguration.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getVersions: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.FunctionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("versions", versions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse
  ) extends zio.aws.lambda.model.ListVersionsByFunctionResponse.ReadOnly {
    override val nextMarker: Option[String] =
      scala.Option(impl.nextMarker()).map(value => value: String)
    override val versions
        : Option[List[zio.aws.lambda.model.FunctionConfiguration.ReadOnly]] =
      scala
        .Option(impl.versions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.FunctionConfiguration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse
  ): zio.aws.lambda.model.ListVersionsByFunctionResponse.ReadOnly = new Wrapper(
    impl
  )
}
