package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{MaxListItems, MasterRegion}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListFunctionsRequest(
    masterRegion: Option[MasterRegion] = None,
    functionVersion: Option[zio.aws.lambda.model.FunctionVersion] = None,
    marker: Option[String] = None,
    maxItems: Option[MaxListItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListFunctionsRequest = {
    import ListFunctionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListFunctionsRequest
      .builder()
      .optionallyWith(
        masterRegion.map(value => MasterRegion.unwrap(value): java.lang.String)
      )(_.masterRegion)
      .optionallyWith(functionVersion.map(value => value.unwrap))(
        _.functionVersion
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxListItems.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListFunctionsRequest.ReadOnly =
    zio.aws.lambda.model.ListFunctionsRequest.wrap(buildAwsValue())
}
object ListFunctionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListFunctionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListFunctionsRequest =
      zio.aws.lambda.model.ListFunctionsRequest(
        masterRegion.map(value => value),
        functionVersion.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def masterRegion: Option[MasterRegion]
    def functionVersion: Option[zio.aws.lambda.model.FunctionVersion]
    def marker: Option[String]
    def maxItems: Option[MaxListItems]
    def getMasterRegion: ZIO[Any, AwsError, MasterRegion] =
      AwsError.unwrapOptionField("masterRegion", masterRegion)
    def getFunctionVersion
        : ZIO[Any, AwsError, zio.aws.lambda.model.FunctionVersion] =
      AwsError.unwrapOptionField("functionVersion", functionVersion)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionsRequest
  ) extends zio.aws.lambda.model.ListFunctionsRequest.ReadOnly {
    override val masterRegion: Option[MasterRegion] = scala
      .Option(impl.masterRegion())
      .map(value => zio.aws.lambda.model.primitives.MasterRegion(value))
    override val functionVersion: Option[zio.aws.lambda.model.FunctionVersion] =
      scala
        .Option(impl.functionVersion())
        .map(value => zio.aws.lambda.model.FunctionVersion.wrap(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[MaxListItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxListItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionsRequest
  ): zio.aws.lambda.model.ListFunctionsRequest.ReadOnly = new Wrapper(impl)
}
