package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{MaxListItems, CodeSigningConfigArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListFunctionsByCodeSigningConfigRequest(
    codeSigningConfigArn: CodeSigningConfigArn,
    marker: Option[String] = None,
    maxItems: Option[MaxListItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest = {
    import ListFunctionsByCodeSigningConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest
      .builder()
      .codeSigningConfigArn(
        CodeSigningConfigArn.unwrap(codeSigningConfigArn): java.lang.String
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxListItems.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.ListFunctionsByCodeSigningConfigRequest.ReadOnly =
    zio.aws.lambda.model.ListFunctionsByCodeSigningConfigRequest
      .wrap(buildAwsValue())
}
object ListFunctionsByCodeSigningConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.ListFunctionsByCodeSigningConfigRequest =
      zio.aws.lambda.model.ListFunctionsByCodeSigningConfigRequest(
        codeSigningConfigArn,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def codeSigningConfigArn: CodeSigningConfigArn
    def marker: Option[String]
    def maxItems: Option[MaxListItems]
    def getCodeSigningConfigArn: ZIO[Any, Nothing, CodeSigningConfigArn] =
      ZIO.succeed(codeSigningConfigArn)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest
  ) extends zio.aws.lambda.model.ListFunctionsByCodeSigningConfigRequest.ReadOnly {
    override val codeSigningConfigArn: CodeSigningConfigArn =
      zio.aws.lambda.model.primitives
        .CodeSigningConfigArn(impl.codeSigningConfigArn())
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[MaxListItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxListItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest
  ): zio.aws.lambda.model.ListFunctionsByCodeSigningConfigRequest.ReadOnly =
    new Wrapper(impl)
}
