package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateCodeSigningConfigResponse(
    codeSigningConfig: zio.aws.lambda.model.CodeSigningConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigResponse = {
    import UpdateCodeSigningConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigResponse
      .builder()
      .codeSigningConfig(codeSigningConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.UpdateCodeSigningConfigResponse.ReadOnly =
    zio.aws.lambda.model.UpdateCodeSigningConfigResponse.wrap(buildAwsValue())
}
object UpdateCodeSigningConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateCodeSigningConfigResponse =
      zio.aws.lambda.model
        .UpdateCodeSigningConfigResponse(codeSigningConfig.asEditable)
    def codeSigningConfig: zio.aws.lambda.model.CodeSigningConfig.ReadOnly
    def getCodeSigningConfig
        : ZIO[Any, Nothing, zio.aws.lambda.model.CodeSigningConfig.ReadOnly] =
      ZIO.succeed(codeSigningConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigResponse
  ) extends zio.aws.lambda.model.UpdateCodeSigningConfigResponse.ReadOnly {
    override val codeSigningConfig
        : zio.aws.lambda.model.CodeSigningConfig.ReadOnly =
      zio.aws.lambda.model.CodeSigningConfig.wrap(impl.codeSigningConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigResponse
  ): zio.aws.lambda.model.UpdateCodeSigningConfigResponse.ReadOnly =
    new Wrapper(impl)
}
