package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAccountSettingsResponse(
    accountLimit: Option[zio.aws.lambda.model.AccountLimit] = None,
    accountUsage: Option[zio.aws.lambda.model.AccountUsage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse = {
    import GetAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse
      .builder()
      .optionallyWith(accountLimit.map(value => value.buildAwsValue()))(
        _.accountLimit
      )
      .optionallyWith(accountUsage.map(value => value.buildAwsValue()))(
        _.accountUsage
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly =
    zio.aws.lambda.model.GetAccountSettingsResponse.wrap(buildAwsValue())
}
object GetAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetAccountSettingsResponse =
      zio.aws.lambda.model.GetAccountSettingsResponse(
        accountLimit.map(value => value.asEditable),
        accountUsage.map(value => value.asEditable)
      )
    def accountLimit: Option[zio.aws.lambda.model.AccountLimit.ReadOnly]
    def accountUsage: Option[zio.aws.lambda.model.AccountUsage.ReadOnly]
    def getAccountLimit
        : ZIO[Any, AwsError, zio.aws.lambda.model.AccountLimit.ReadOnly] =
      AwsError.unwrapOptionField("accountLimit", accountLimit)
    def getAccountUsage
        : ZIO[Any, AwsError, zio.aws.lambda.model.AccountUsage.ReadOnly] =
      AwsError.unwrapOptionField("accountUsage", accountUsage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse
  ) extends zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly {
    override val accountLimit
        : Option[zio.aws.lambda.model.AccountLimit.ReadOnly] = scala
      .Option(impl.accountLimit())
      .map(value => zio.aws.lambda.model.AccountLimit.wrap(value))
    override val accountUsage
        : Option[zio.aws.lambda.model.AccountUsage.ReadOnly] = scala
      .Option(impl.accountUsage())
      .map(value => zio.aws.lambda.model.AccountUsage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse
  ): zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
