package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{
  MaximumEventAgeInSeconds,
  MaximumRetryAttempts,
  Qualifier,
  FunctionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateFunctionEventInvokeConfigRequest(
    functionName: FunctionName,
    qualifier: Option[Qualifier] = None,
    maximumRetryAttempts: Option[MaximumRetryAttempts] = None,
    maximumEventAgeInSeconds: Option[MaximumEventAgeInSeconds] = None,
    destinationConfig: Option[zio.aws.lambda.model.DestinationConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest = {
    import UpdateFunctionEventInvokeConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttempts.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        maximumEventAgeInSeconds.map(value =>
          MaximumEventAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumEventAgeInSeconds)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.UpdateFunctionEventInvokeConfigRequest.ReadOnly =
    zio.aws.lambda.model.UpdateFunctionEventInvokeConfigRequest
      .wrap(buildAwsValue())
}
object UpdateFunctionEventInvokeConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.UpdateFunctionEventInvokeConfigRequest =
      zio.aws.lambda.model.UpdateFunctionEventInvokeConfigRequest(
        functionName,
        qualifier.map(value => value),
        maximumRetryAttempts.map(value => value),
        maximumEventAgeInSeconds.map(value => value),
        destinationConfig.map(value => value.asEditable)
      )
    def functionName: FunctionName
    def qualifier: Option[Qualifier]
    def maximumRetryAttempts: Option[MaximumRetryAttempts]
    def maximumEventAgeInSeconds: Option[MaximumEventAgeInSeconds]
    def destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
    def getMaximumRetryAttempts: ZIO[Any, AwsError, MaximumRetryAttempts] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getMaximumEventAgeInSeconds
        : ZIO[Any, AwsError, MaximumEventAgeInSeconds] = AwsError
      .unwrapOptionField("maximumEventAgeInSeconds", maximumEventAgeInSeconds)
    def getDestinationConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      AwsError.unwrapOptionField("destinationConfig", destinationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest
  ) extends zio.aws.lambda.model.UpdateFunctionEventInvokeConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Option[Qualifier] = scala
      .Option(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
    override val maximumRetryAttempts: Option[MaximumRetryAttempts] = scala
      .Option(impl.maximumRetryAttempts())
      .map(value => zio.aws.lambda.model.primitives.MaximumRetryAttempts(value))
    override val maximumEventAgeInSeconds: Option[MaximumEventAgeInSeconds] =
      scala
        .Option(impl.maximumEventAgeInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.MaximumEventAgeInSeconds(value)
        )
    override val destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly] = scala
      .Option(impl.destinationConfig())
      .map(value => zio.aws.lambda.model.DestinationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest
  ): zio.aws.lambda.model.UpdateFunctionEventInvokeConfigRequest.ReadOnly =
    new Wrapper(impl)
}
