package zio.aws.lambda.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  MaximumEventAgeInSeconds,
  MaximumRetryAttempts,
  FunctionArn,
  Date
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PutFunctionEventInvokeConfigResponse(
    lastModified: Option[Date] = None,
    functionArn: Option[FunctionArn] = None,
    maximumRetryAttempts: Option[MaximumRetryAttempts] = None,
    maximumEventAgeInSeconds: Option[MaximumEventAgeInSeconds] = None,
    destinationConfig: Option[zio.aws.lambda.model.DestinationConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigResponse = {
    import PutFunctionEventInvokeConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigResponse
      .builder()
      .optionallyWith(lastModified.map(value => Date.unwrap(value): Instant))(
        _.lastModified
      )
      .optionallyWith(
        functionArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.functionArn)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttempts.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        maximumEventAgeInSeconds.map(value =>
          MaximumEventAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumEventAgeInSeconds)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse.ReadOnly =
    zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse
      .wrap(buildAwsValue())
}
object PutFunctionEventInvokeConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse =
      zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse(
        lastModified.map(value => value),
        functionArn.map(value => value),
        maximumRetryAttempts.map(value => value),
        maximumEventAgeInSeconds.map(value => value),
        destinationConfig.map(value => value.asEditable)
      )
    def lastModified: Option[Date]
    def functionArn: Option[FunctionArn]
    def maximumRetryAttempts: Option[MaximumRetryAttempts]
    def maximumEventAgeInSeconds: Option[MaximumEventAgeInSeconds]
    def destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly]
    def getLastModified: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getFunctionArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getMaximumRetryAttempts: ZIO[Any, AwsError, MaximumRetryAttempts] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getMaximumEventAgeInSeconds
        : ZIO[Any, AwsError, MaximumEventAgeInSeconds] = AwsError
      .unwrapOptionField("maximumEventAgeInSeconds", maximumEventAgeInSeconds)
    def getDestinationConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      AwsError.unwrapOptionField("destinationConfig", destinationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigResponse
  ) extends zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse.ReadOnly {
    override val lastModified: Option[Date] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.lambda.model.primitives.Date(value))
    override val functionArn: Option[FunctionArn] = scala
      .Option(impl.functionArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val maximumRetryAttempts: Option[MaximumRetryAttempts] = scala
      .Option(impl.maximumRetryAttempts())
      .map(value => zio.aws.lambda.model.primitives.MaximumRetryAttempts(value))
    override val maximumEventAgeInSeconds: Option[MaximumEventAgeInSeconds] =
      scala
        .Option(impl.maximumEventAgeInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.MaximumEventAgeInSeconds(value)
        )
    override val destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly] = scala
      .Option(impl.destinationConfig())
      .map(value => zio.aws.lambda.model.DestinationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigResponse
  ): zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse.ReadOnly =
    new Wrapper(impl)
}
