package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, FunctionName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetProvisionedConcurrencyConfigRequest(
    functionName: FunctionName,
    qualifier: Qualifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest = {
    import GetProvisionedConcurrencyConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .qualifier(Qualifier.unwrap(qualifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.GetProvisionedConcurrencyConfigRequest.ReadOnly =
    zio.aws.lambda.model.GetProvisionedConcurrencyConfigRequest
      .wrap(buildAwsValue())
}
object GetProvisionedConcurrencyConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.GetProvisionedConcurrencyConfigRequest =
      zio.aws.lambda.model
        .GetProvisionedConcurrencyConfigRequest(functionName, qualifier)
    def functionName: FunctionName
    def qualifier: Qualifier
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, Nothing, Qualifier] = ZIO.succeed(qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest
  ) extends zio.aws.lambda.model.GetProvisionedConcurrencyConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Qualifier =
      zio.aws.lambda.model.primitives.Qualifier(impl.qualifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest
  ): zio.aws.lambda.model.GetProvisionedConcurrencyConfigRequest.ReadOnly =
    new Wrapper(impl)
}
