package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.ReservedConcurrentExecutions
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutFunctionConcurrencyResponse(
    reservedConcurrentExecutions: Option[ReservedConcurrentExecutions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse = {
    import PutFunctionConcurrencyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse
      .builder()
      .optionallyWith(
        reservedConcurrentExecutions.map(value =>
          ReservedConcurrentExecutions.unwrap(value): Integer
        )
      )(_.reservedConcurrentExecutions)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.PutFunctionConcurrencyResponse.ReadOnly =
    zio.aws.lambda.model.PutFunctionConcurrencyResponse.wrap(buildAwsValue())
}
object PutFunctionConcurrencyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PutFunctionConcurrencyResponse =
      zio.aws.lambda.model.PutFunctionConcurrencyResponse(
        reservedConcurrentExecutions.map(value => value)
      )
    def reservedConcurrentExecutions: Option[ReservedConcurrentExecutions]
    def getReservedConcurrentExecutions
        : ZIO[Any, AwsError, ReservedConcurrentExecutions] =
      AwsError.unwrapOptionField(
        "reservedConcurrentExecutions",
        reservedConcurrentExecutions
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse
  ) extends zio.aws.lambda.model.PutFunctionConcurrencyResponse.ReadOnly {
    override val reservedConcurrentExecutions
        : Option[ReservedConcurrentExecutions] = scala
      .Option(impl.reservedConcurrentExecutions())
      .map(value =>
        zio.aws.lambda.model.primitives.ReservedConcurrentExecutions(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse
  ): zio.aws.lambda.model.PutFunctionConcurrencyResponse.ReadOnly = new Wrapper(
    impl
  )
}
