package zio.aws.lambda.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  MaximumRetryAttemptsEventSourceMapping,
  BatchSize,
  BisectBatchOnFunctionError,
  Date,
  MaximumBatchingWindowInSeconds,
  Queue,
  Arn,
  ParallelizationFactor,
  FunctionArn,
  Topic,
  TumblingWindowInSeconds,
  MaximumRecordAgeInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetEventSourceMappingResponse(
    uuid: Option[String] = None,
    startingPosition: Option[zio.aws.lambda.model.EventSourcePosition] = None,
    startingPositionTimestamp: Option[Date] = None,
    batchSize: Option[BatchSize] = None,
    maximumBatchingWindowInSeconds: Option[MaximumBatchingWindowInSeconds] =
      None,
    parallelizationFactor: Option[ParallelizationFactor] = None,
    eventSourceArn: Option[Arn] = None,
    filterCriteria: Option[zio.aws.lambda.model.FilterCriteria] = None,
    functionArn: Option[FunctionArn] = None,
    lastModified: Option[Date] = None,
    lastProcessingResult: Option[String] = None,
    state: Option[String] = None,
    stateTransitionReason: Option[String] = None,
    destinationConfig: Option[zio.aws.lambda.model.DestinationConfig] = None,
    topics: Option[Iterable[Topic]] = None,
    queues: Option[Iterable[Queue]] = None,
    sourceAccessConfigurations: Option[
      Iterable[zio.aws.lambda.model.SourceAccessConfiguration]
    ] = None,
    selfManagedEventSource: Option[
      zio.aws.lambda.model.SelfManagedEventSource
    ] = None,
    maximumRecordAgeInSeconds: Option[MaximumRecordAgeInSeconds] = None,
    bisectBatchOnFunctionError: Option[BisectBatchOnFunctionError] = None,
    maximumRetryAttempts: Option[MaximumRetryAttemptsEventSourceMapping] = None,
    tumblingWindowInSeconds: Option[TumblingWindowInSeconds] = None,
    functionResponseTypes: Option[
      Iterable[zio.aws.lambda.model.FunctionResponseType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse = {
    import GetEventSourceMappingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse
      .builder()
      .optionallyWith(uuid.map(value => value: java.lang.String))(_.uuid)
      .optionallyWith(startingPosition.map(value => value.unwrap))(
        _.startingPosition
      )
      .optionallyWith(
        startingPositionTimestamp.map(value => Date.unwrap(value): Instant)
      )(_.startingPositionTimestamp)
      .optionallyWith(batchSize.map(value => BatchSize.unwrap(value): Integer))(
        _.batchSize
      )
      .optionallyWith(
        maximumBatchingWindowInSeconds.map(value =>
          MaximumBatchingWindowInSeconds.unwrap(value): Integer
        )
      )(_.maximumBatchingWindowInSeconds)
      .optionallyWith(
        parallelizationFactor.map(value =>
          ParallelizationFactor.unwrap(value): Integer
        )
      )(_.parallelizationFactor)
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        functionArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.functionArn)
      .optionallyWith(lastModified.map(value => Date.unwrap(value): Instant))(
        _.lastModified
      )
      .optionallyWith(
        lastProcessingResult.map(value => value: java.lang.String)
      )(_.lastProcessingResult)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        stateTransitionReason.map(value => value: java.lang.String)
      )(_.stateTransitionReason)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(
        topics.map(value =>
          value.map { item =>
            Topic.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.topics)
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            Queue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queues)
      .optionallyWith(
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceAccessConfigurations)
      .optionallyWith(
        selfManagedEventSource.map(value => value.buildAwsValue())
      )(_.selfManagedEventSource)
      .optionallyWith(
        maximumRecordAgeInSeconds.map(value =>
          MaximumRecordAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumRecordAgeInSeconds)
      .optionallyWith(
        bisectBatchOnFunctionError.map(value =>
          BisectBatchOnFunctionError.unwrap(value): java.lang.Boolean
        )
      )(_.bisectBatchOnFunctionError)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttemptsEventSourceMapping.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        tumblingWindowInSeconds.map(value =>
          TumblingWindowInSeconds.unwrap(value): Integer
        )
      )(_.tumblingWindowInSeconds)
      .optionallyWith(
        functionResponseTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.functionResponseTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetEventSourceMappingResponse.ReadOnly =
    zio.aws.lambda.model.GetEventSourceMappingResponse.wrap(buildAwsValue())
}
object GetEventSourceMappingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetEventSourceMappingResponse =
      zio.aws.lambda.model.GetEventSourceMappingResponse(
        uuid.map(value => value),
        startingPosition.map(value => value),
        startingPositionTimestamp.map(value => value),
        batchSize.map(value => value),
        maximumBatchingWindowInSeconds.map(value => value),
        parallelizationFactor.map(value => value),
        eventSourceArn.map(value => value),
        filterCriteria.map(value => value.asEditable),
        functionArn.map(value => value),
        lastModified.map(value => value),
        lastProcessingResult.map(value => value),
        state.map(value => value),
        stateTransitionReason.map(value => value),
        destinationConfig.map(value => value.asEditable),
        topics.map(value => value),
        queues.map(value => value),
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        selfManagedEventSource.map(value => value.asEditable),
        maximumRecordAgeInSeconds.map(value => value),
        bisectBatchOnFunctionError.map(value => value),
        maximumRetryAttempts.map(value => value),
        tumblingWindowInSeconds.map(value => value),
        functionResponseTypes.map(value => value)
      )
    def uuid: Option[String]
    def startingPosition: Option[zio.aws.lambda.model.EventSourcePosition]
    def startingPositionTimestamp: Option[Date]
    def batchSize: Option[BatchSize]
    def maximumBatchingWindowInSeconds: Option[MaximumBatchingWindowInSeconds]
    def parallelizationFactor: Option[ParallelizationFactor]
    def eventSourceArn: Option[Arn]
    def filterCriteria: Option[zio.aws.lambda.model.FilterCriteria.ReadOnly]
    def functionArn: Option[FunctionArn]
    def lastModified: Option[Date]
    def lastProcessingResult: Option[String]
    def state: Option[String]
    def stateTransitionReason: Option[String]
    def destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly]
    def topics: Option[List[Topic]]
    def queues: Option[List[Queue]]
    def sourceAccessConfigurations
        : Option[List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]]
    def selfManagedEventSource
        : Option[zio.aws.lambda.model.SelfManagedEventSource.ReadOnly]
    def maximumRecordAgeInSeconds: Option[MaximumRecordAgeInSeconds]
    def bisectBatchOnFunctionError: Option[BisectBatchOnFunctionError]
    def maximumRetryAttempts: Option[MaximumRetryAttemptsEventSourceMapping]
    def tumblingWindowInSeconds: Option[TumblingWindowInSeconds]
    def functionResponseTypes
        : Option[List[zio.aws.lambda.model.FunctionResponseType]]
    def getUuid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uuid", uuid)
    def getStartingPosition
        : ZIO[Any, AwsError, zio.aws.lambda.model.EventSourcePosition] =
      AwsError.unwrapOptionField("startingPosition", startingPosition)
    def getStartingPositionTimestamp: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("startingPositionTimestamp", startingPositionTimestamp)
    def getBatchSize: ZIO[Any, AwsError, BatchSize] =
      AwsError.unwrapOptionField("batchSize", batchSize)
    def getMaximumBatchingWindowInSeconds
        : ZIO[Any, AwsError, MaximumBatchingWindowInSeconds] =
      AwsError.unwrapOptionField(
        "maximumBatchingWindowInSeconds",
        maximumBatchingWindowInSeconds
      )
    def getParallelizationFactor: ZIO[Any, AwsError, ParallelizationFactor] =
      AwsError.unwrapOptionField("parallelizationFactor", parallelizationFactor)
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.lambda.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getFunctionArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getLastModified: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getLastProcessingResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastProcessingResult", lastProcessingResult)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getStateTransitionReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateTransitionReason", stateTransitionReason)
    def getDestinationConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getTopics: ZIO[Any, AwsError, List[Topic]] =
      AwsError.unwrapOptionField("topics", topics)
    def getQueues: ZIO[Any, AwsError, List[Queue]] =
      AwsError.unwrapOptionField("queues", queues)
    def getSourceAccessConfigurations: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceAccessConfigurations",
      sourceAccessConfigurations
    )
    def getSelfManagedEventSource: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.SelfManagedEventSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedEventSource",
      selfManagedEventSource
    )
    def getMaximumRecordAgeInSeconds
        : ZIO[Any, AwsError, MaximumRecordAgeInSeconds] = AwsError
      .unwrapOptionField("maximumRecordAgeInSeconds", maximumRecordAgeInSeconds)
    def getBisectBatchOnFunctionError
        : ZIO[Any, AwsError, BisectBatchOnFunctionError] =
      AwsError.unwrapOptionField(
        "bisectBatchOnFunctionError",
        bisectBatchOnFunctionError
      )
    def getMaximumRetryAttempts
        : ZIO[Any, AwsError, MaximumRetryAttemptsEventSourceMapping] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getTumblingWindowInSeconds
        : ZIO[Any, AwsError, TumblingWindowInSeconds] = AwsError
      .unwrapOptionField("tumblingWindowInSeconds", tumblingWindowInSeconds)
    def getFunctionResponseTypes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.FunctionResponseType]] =
      AwsError.unwrapOptionField("functionResponseTypes", functionResponseTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse
  ) extends zio.aws.lambda.model.GetEventSourceMappingResponse.ReadOnly {
    override val uuid: Option[String] =
      scala.Option(impl.uuid()).map(value => value: String)
    override val startingPosition
        : Option[zio.aws.lambda.model.EventSourcePosition] = scala
      .Option(impl.startingPosition())
      .map(value => zio.aws.lambda.model.EventSourcePosition.wrap(value))
    override val startingPositionTimestamp: Option[Date] = scala
      .Option(impl.startingPositionTimestamp())
      .map(value => zio.aws.lambda.model.primitives.Date(value))
    override val batchSize: Option[BatchSize] = scala
      .Option(impl.batchSize())
      .map(value => zio.aws.lambda.model.primitives.BatchSize(value))
    override val maximumBatchingWindowInSeconds
        : Option[MaximumBatchingWindowInSeconds] = scala
      .Option(impl.maximumBatchingWindowInSeconds())
      .map(value =>
        zio.aws.lambda.model.primitives.MaximumBatchingWindowInSeconds(value)
      )
    override val parallelizationFactor: Option[ParallelizationFactor] = scala
      .Option(impl.parallelizationFactor())
      .map(value =>
        zio.aws.lambda.model.primitives.ParallelizationFactor(value)
      )
    override val eventSourceArn: Option[Arn] = scala
      .Option(impl.eventSourceArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val filterCriteria
        : Option[zio.aws.lambda.model.FilterCriteria.ReadOnly] = scala
      .Option(impl.filterCriteria())
      .map(value => zio.aws.lambda.model.FilterCriteria.wrap(value))
    override val functionArn: Option[FunctionArn] = scala
      .Option(impl.functionArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val lastModified: Option[Date] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.lambda.model.primitives.Date(value))
    override val lastProcessingResult: Option[String] =
      scala.Option(impl.lastProcessingResult()).map(value => value: String)
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val stateTransitionReason: Option[String] =
      scala.Option(impl.stateTransitionReason()).map(value => value: String)
    override val destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly] = scala
      .Option(impl.destinationConfig())
      .map(value => zio.aws.lambda.model.DestinationConfig.wrap(value))
    override val topics: Option[List[Topic]] = scala
      .Option(impl.topics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Topic(item)
        }.toList
      )
    override val queues: Option[List[Queue]] = scala
      .Option(impl.queues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Queue(item)
        }.toList
      )
    override val sourceAccessConfigurations: Option[
      List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]
    ] = scala
      .Option(impl.sourceAccessConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.SourceAccessConfiguration.wrap(item)
        }.toList
      )
    override val selfManagedEventSource
        : Option[zio.aws.lambda.model.SelfManagedEventSource.ReadOnly] = scala
      .Option(impl.selfManagedEventSource())
      .map(value => zio.aws.lambda.model.SelfManagedEventSource.wrap(value))
    override val maximumRecordAgeInSeconds: Option[MaximumRecordAgeInSeconds] =
      scala
        .Option(impl.maximumRecordAgeInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.MaximumRecordAgeInSeconds(value)
        )
    override val bisectBatchOnFunctionError
        : Option[BisectBatchOnFunctionError] = scala
      .Option(impl.bisectBatchOnFunctionError())
      .map(value =>
        zio.aws.lambda.model.primitives.BisectBatchOnFunctionError(value)
      )
    override val maximumRetryAttempts
        : Option[MaximumRetryAttemptsEventSourceMapping] = scala
      .Option(impl.maximumRetryAttempts())
      .map(value =>
        zio.aws.lambda.model.primitives
          .MaximumRetryAttemptsEventSourceMapping(value)
      )
    override val tumblingWindowInSeconds: Option[TumblingWindowInSeconds] =
      scala
        .Option(impl.tumblingWindowInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.TumblingWindowInSeconds(value)
        )
    override val functionResponseTypes
        : Option[List[zio.aws.lambda.model.FunctionResponseType]] = scala
      .Option(impl.functionResponseTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.FunctionResponseType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse
  ): zio.aws.lambda.model.GetEventSourceMappingResponse.ReadOnly = new Wrapper(
    impl
  )
}
