package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, FunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteFunctionEventInvokeConfigRequest(
    functionName: FunctionName,
    qualifier: Option[Qualifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest = {
    import DeleteFunctionEventInvokeConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.DeleteFunctionEventInvokeConfigRequest.ReadOnly =
    zio.aws.lambda.model.DeleteFunctionEventInvokeConfigRequest
      .wrap(buildAwsValue())
}
object DeleteFunctionEventInvokeConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.DeleteFunctionEventInvokeConfigRequest =
      zio.aws.lambda.model.DeleteFunctionEventInvokeConfigRequest(
        functionName,
        qualifier.map(value => value)
      )
    def functionName: FunctionName
    def qualifier: Option[Qualifier]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest
  ) extends zio.aws.lambda.model.DeleteFunctionEventInvokeConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Option[Qualifier] = scala
      .Option(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest
  ): zio.aws.lambda.model.DeleteFunctionEventInvokeConfigRequest.ReadOnly =
    new Wrapper(impl)
}
