package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.FunctionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsRequest(resource: FunctionArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListTagsRequest = {
    import ListTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListTagsRequest
      .builder()
      .resource(FunctionArn.unwrap(resource): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListTagsRequest.ReadOnly =
    zio.aws.lambda.model.ListTagsRequest.wrap(buildAwsValue())
}
object ListTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListTagsRequest =
      zio.aws.lambda.model.ListTagsRequest(resource)
    def resource: FunctionArn
    def getResource: ZIO[Any, Nothing, FunctionArn] = ZIO.succeed(resource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListTagsRequest
  ) extends zio.aws.lambda.model.ListTagsRequest.ReadOnly {
    override val resource: FunctionArn =
      zio.aws.lambda.model.primitives.FunctionArn(impl.resource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListTagsRequest
  ): zio.aws.lambda.model.ListTagsRequest.ReadOnly = new Wrapper(impl)
}
