package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListProvisionedConcurrencyConfigsResponse(
    provisionedConcurrencyConfigs: Option[
      Iterable[zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem]
    ] = None,
    nextMarker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse = {
    import ListProvisionedConcurrencyConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse
      .builder()
      .optionallyWith(
        provisionedConcurrencyConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedConcurrencyConfigs)
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse.ReadOnly =
    zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse
      .wrap(buildAwsValue())
}
object ListProvisionedConcurrencyConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse =
      zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse(
        provisionedConcurrencyConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def provisionedConcurrencyConfigs: Option[
      List[zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly]
    ]
    def nextMarker: Option[String]
    def getProvisionedConcurrencyConfigs: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisionedConcurrencyConfigs",
      provisionedConcurrencyConfigs
    )
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse
  ) extends zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse.ReadOnly {
    override val provisionedConcurrencyConfigs: Option[
      List[zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly]
    ] = scala
      .Option(impl.provisionedConcurrencyConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.wrap(item)
        }.toList
      )
    override val nextMarker: Option[String] =
      scala.Option(impl.nextMarker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse
  ): zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
