package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  Timestamp,
  Description,
  CodeSigningConfigArn,
  CodeSigningConfigId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CodeSigningConfig(
    codeSigningConfigId: CodeSigningConfigId,
    codeSigningConfigArn: CodeSigningConfigArn,
    description: Option[Description] = None,
    allowedPublishers: zio.aws.lambda.model.AllowedPublishers,
    codeSigningPolicies: zio.aws.lambda.model.CodeSigningPolicies,
    lastModified: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CodeSigningConfig = {
    import CodeSigningConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CodeSigningConfig
      .builder()
      .codeSigningConfigId(
        CodeSigningConfigId.unwrap(codeSigningConfigId): java.lang.String
      )
      .codeSigningConfigArn(
        CodeSigningConfigArn.unwrap(codeSigningConfigArn): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .allowedPublishers(allowedPublishers.buildAwsValue())
      .codeSigningPolicies(codeSigningPolicies.buildAwsValue())
      .lastModified(Timestamp.unwrap(lastModified): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.CodeSigningConfig.ReadOnly =
    zio.aws.lambda.model.CodeSigningConfig.wrap(buildAwsValue())
}
object CodeSigningConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CodeSigningConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CodeSigningConfig =
      zio.aws.lambda.model.CodeSigningConfig(
        codeSigningConfigId,
        codeSigningConfigArn,
        description.map(value => value),
        allowedPublishers.asEditable,
        codeSigningPolicies.asEditable,
        lastModified
      )
    def codeSigningConfigId: CodeSigningConfigId
    def codeSigningConfigArn: CodeSigningConfigArn
    def description: Option[Description]
    def allowedPublishers: zio.aws.lambda.model.AllowedPublishers.ReadOnly
    def codeSigningPolicies: zio.aws.lambda.model.CodeSigningPolicies.ReadOnly
    def lastModified: Timestamp
    def getCodeSigningConfigId: ZIO[Any, Nothing, CodeSigningConfigId] =
      ZIO.succeed(codeSigningConfigId)
    def getCodeSigningConfigArn: ZIO[Any, Nothing, CodeSigningConfigArn] =
      ZIO.succeed(codeSigningConfigArn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getAllowedPublishers
        : ZIO[Any, Nothing, zio.aws.lambda.model.AllowedPublishers.ReadOnly] =
      ZIO.succeed(allowedPublishers)
    def getCodeSigningPolicies
        : ZIO[Any, Nothing, zio.aws.lambda.model.CodeSigningPolicies.ReadOnly] =
      ZIO.succeed(codeSigningPolicies)
    def getLastModified: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CodeSigningConfig
  ) extends zio.aws.lambda.model.CodeSigningConfig.ReadOnly {
    override val codeSigningConfigId: CodeSigningConfigId =
      zio.aws.lambda.model.primitives
        .CodeSigningConfigId(impl.codeSigningConfigId())
    override val codeSigningConfigArn: CodeSigningConfigArn =
      zio.aws.lambda.model.primitives
        .CodeSigningConfigArn(impl.codeSigningConfigArn())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val allowedPublishers
        : zio.aws.lambda.model.AllowedPublishers.ReadOnly =
      zio.aws.lambda.model.AllowedPublishers.wrap(impl.allowedPublishers())
    override val codeSigningPolicies
        : zio.aws.lambda.model.CodeSigningPolicies.ReadOnly =
      zio.aws.lambda.model.CodeSigningPolicies.wrap(impl.codeSigningPolicies())
    override val lastModified: Timestamp =
      zio.aws.lambda.model.primitives.Timestamp(impl.lastModified())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CodeSigningConfig
  ): zio.aws.lambda.model.CodeSigningConfig.ReadOnly = new Wrapper(impl)
}
