package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, Blob, NamespacedFunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InvokeRequest(
    functionName: NamespacedFunctionName,
    invocationType: Option[zio.aws.lambda.model.InvocationType] = None,
    logType: Option[zio.aws.lambda.model.LogType] = None,
    clientContext: Option[String] = None,
    payload: Option[Blob] = None,
    qualifier: Option[Qualifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.InvokeRequest = {
    import InvokeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.InvokeRequest
      .builder()
      .functionName(
        NamespacedFunctionName.unwrap(functionName): java.lang.String
      )
      .optionallyWith(invocationType.map(value => value.unwrap))(
        _.invocationType
      )
      .optionallyWith(logType.map(value => value.unwrap))(_.logType)
      .optionallyWith(clientContext.map(value => value: java.lang.String))(
        _.clientContext
      )
      .optionallyWith(
        payload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.payload)
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.InvokeRequest.ReadOnly =
    zio.aws.lambda.model.InvokeRequest.wrap(buildAwsValue())
}
object InvokeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.InvokeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.InvokeRequest =
      zio.aws.lambda.model.InvokeRequest(
        functionName,
        invocationType.map(value => value),
        logType.map(value => value),
        clientContext.map(value => value),
        payload.map(value => value),
        qualifier.map(value => value)
      )
    def functionName: NamespacedFunctionName
    def invocationType: Option[zio.aws.lambda.model.InvocationType]
    def logType: Option[zio.aws.lambda.model.LogType]
    def clientContext: Option[String]
    def payload: Option[Blob]
    def qualifier: Option[Qualifier]
    def getFunctionName: ZIO[Any, Nothing, NamespacedFunctionName] =
      ZIO.succeed(functionName)
    def getInvocationType
        : ZIO[Any, AwsError, zio.aws.lambda.model.InvocationType] =
      AwsError.unwrapOptionField("invocationType", invocationType)
    def getLogType: ZIO[Any, AwsError, zio.aws.lambda.model.LogType] =
      AwsError.unwrapOptionField("logType", logType)
    def getClientContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientContext", clientContext)
    def getPayload: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("payload", payload)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.InvokeRequest
  ) extends zio.aws.lambda.model.InvokeRequest.ReadOnly {
    override val functionName: NamespacedFunctionName =
      zio.aws.lambda.model.primitives
        .NamespacedFunctionName(impl.functionName())
    override val invocationType: Option[zio.aws.lambda.model.InvocationType] =
      scala
        .Option(impl.invocationType())
        .map(value => zio.aws.lambda.model.InvocationType.wrap(value))
    override val logType: Option[zio.aws.lambda.model.LogType] = scala
      .Option(impl.logType())
      .map(value => zio.aws.lambda.model.LogType.wrap(value))
    override val clientContext: Option[String] =
      scala.Option(impl.clientContext()).map(value => value: String)
    override val payload: Option[Blob] = scala
      .Option(impl.payload())
      .map(value =>
        zio.aws.lambda.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val qualifier: Option[Qualifier] = scala
      .Option(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.InvokeRequest
  ): zio.aws.lambda.model.InvokeRequest.ReadOnly = new Wrapper(impl)
}
