package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{UnreservedConcurrentExecutions, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccountLimit(
    totalCodeSize: Option[Long] = None,
    codeSizeUnzipped: Option[Long] = None,
    codeSizeZipped: Option[Long] = None,
    concurrentExecutions: Option[Integer] = None,
    unreservedConcurrentExecutions: Option[UnreservedConcurrentExecutions] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AccountLimit = {
    import AccountLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AccountLimit
      .builder()
      .optionallyWith(totalCodeSize.map(value => value: java.lang.Long))(
        _.totalCodeSize
      )
      .optionallyWith(codeSizeUnzipped.map(value => value: java.lang.Long))(
        _.codeSizeUnzipped
      )
      .optionallyWith(codeSizeZipped.map(value => value: java.lang.Long))(
        _.codeSizeZipped
      )
      .optionallyWith(
        concurrentExecutions.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.concurrentExecutions)
      .optionallyWith(
        unreservedConcurrentExecutions.map(value =>
          UnreservedConcurrentExecutions.unwrap(value): java.lang.Integer
        )
      )(_.unreservedConcurrentExecutions)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.AccountLimit.ReadOnly =
    zio.aws.lambda.model.AccountLimit.wrap(buildAwsValue())
}
object AccountLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AccountLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AccountLimit =
      zio.aws.lambda.model.AccountLimit(
        totalCodeSize.map(value => value),
        codeSizeUnzipped.map(value => value),
        codeSizeZipped.map(value => value),
        concurrentExecutions.map(value => value),
        unreservedConcurrentExecutions.map(value => value)
      )
    def totalCodeSize: Option[Long]
    def codeSizeUnzipped: Option[Long]
    def codeSizeZipped: Option[Long]
    def concurrentExecutions: Option[Integer]
    def unreservedConcurrentExecutions: Option[UnreservedConcurrentExecutions]
    def getTotalCodeSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalCodeSize", totalCodeSize)
    def getCodeSizeUnzipped: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("codeSizeUnzipped", codeSizeUnzipped)
    def getCodeSizeZipped: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("codeSizeZipped", codeSizeZipped)
    def getConcurrentExecutions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("concurrentExecutions", concurrentExecutions)
    def getUnreservedConcurrentExecutions
        : ZIO[Any, AwsError, UnreservedConcurrentExecutions] =
      AwsError.unwrapOptionField(
        "unreservedConcurrentExecutions",
        unreservedConcurrentExecutions
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AccountLimit
  ) extends zio.aws.lambda.model.AccountLimit.ReadOnly {
    override val totalCodeSize: Option[Long] =
      scala.Option(impl.totalCodeSize()).map(value => value: Long)
    override val codeSizeUnzipped: Option[Long] =
      scala.Option(impl.codeSizeUnzipped()).map(value => value: Long)
    override val codeSizeZipped: Option[Long] =
      scala.Option(impl.codeSizeZipped()).map(value => value: Long)
    override val concurrentExecutions: Option[Integer] = scala
      .Option(impl.concurrentExecutions())
      .map(value => zio.aws.lambda.model.primitives.Integer(value))
    override val unreservedConcurrentExecutions
        : Option[UnreservedConcurrentExecutions] = scala
      .Option(impl.unreservedConcurrentExecutions())
      .map(value =>
        zio.aws.lambda.model.primitives.UnreservedConcurrentExecutions(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AccountLimit
  ): zio.aws.lambda.model.AccountLimit.ReadOnly = new Wrapper(impl)
}
