package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TracingConfig(
    mode: Option[zio.aws.lambda.model.TracingMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.TracingConfig = {
    import TracingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.TracingConfig
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.TracingConfig.ReadOnly =
    zio.aws.lambda.model.TracingConfig.wrap(buildAwsValue())
}
object TracingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.TracingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.TracingConfig =
      zio.aws.lambda.model.TracingConfig(mode.map(value => value))
    def mode: Option[zio.aws.lambda.model.TracingMode]
    def getMode: ZIO[Any, AwsError, zio.aws.lambda.model.TracingMode] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.TracingConfig
  ) extends zio.aws.lambda.model.TracingConfig.ReadOnly {
    override val mode: Option[zio.aws.lambda.model.TracingMode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.lambda.model.TracingMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.TracingConfig
  ): zio.aws.lambda.model.TracingConfig.ReadOnly = new Wrapper(impl)
}
