package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.Description
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCodeSigningConfigRequest(
    description: Option[Description] = None,
    allowedPublishers: zio.aws.lambda.model.AllowedPublishers,
    codeSigningPolicies: Option[zio.aws.lambda.model.CodeSigningPolicies] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest = {
    import CreateCodeSigningConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .allowedPublishers(allowedPublishers.buildAwsValue())
      .optionallyWith(codeSigningPolicies.map(value => value.buildAwsValue()))(
        _.codeSigningPolicies
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.CreateCodeSigningConfigRequest.ReadOnly =
    zio.aws.lambda.model.CreateCodeSigningConfigRequest.wrap(buildAwsValue())
}
object CreateCodeSigningConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CreateCodeSigningConfigRequest =
      zio.aws.lambda.model.CreateCodeSigningConfigRequest(
        description.map(value => value),
        allowedPublishers.asEditable,
        codeSigningPolicies.map(value => value.asEditable)
      )
    def description: Option[Description]
    def allowedPublishers: zio.aws.lambda.model.AllowedPublishers.ReadOnly
    def codeSigningPolicies
        : Option[zio.aws.lambda.model.CodeSigningPolicies.ReadOnly]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getAllowedPublishers
        : ZIO[Any, Nothing, zio.aws.lambda.model.AllowedPublishers.ReadOnly] =
      ZIO.succeed(allowedPublishers)
    def getCodeSigningPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.CodeSigningPolicies.ReadOnly
    ] = AwsError.unwrapOptionField("codeSigningPolicies", codeSigningPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest
  ) extends zio.aws.lambda.model.CreateCodeSigningConfigRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val allowedPublishers
        : zio.aws.lambda.model.AllowedPublishers.ReadOnly =
      zio.aws.lambda.model.AllowedPublishers.wrap(impl.allowedPublishers())
    override val codeSigningPolicies
        : Option[zio.aws.lambda.model.CodeSigningPolicies.ReadOnly] = scala
      .Option(impl.codeSigningPolicies())
      .map(value => zio.aws.lambda.model.CodeSigningPolicies.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest
  ): zio.aws.lambda.model.CreateCodeSigningConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
