package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{
  Timeout,
  RoleArn,
  KMSKeyArn,
  MemorySize,
  LayerVersionArn,
  Description,
  FunctionName,
  Handler
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateFunctionConfigurationRequest(
    functionName: FunctionName,
    role: Option[RoleArn] = None,
    handler: Option[Handler] = None,
    description: Option[Description] = None,
    timeout: Option[Timeout] = None,
    memorySize: Option[MemorySize] = None,
    vpcConfig: Option[zio.aws.lambda.model.VpcConfig] = None,
    environment: Option[zio.aws.lambda.model.Environment] = None,
    runtime: Option[zio.aws.lambda.model.Runtime] = None,
    deadLetterConfig: Option[zio.aws.lambda.model.DeadLetterConfig] = None,
    kmsKeyArn: Option[KMSKeyArn] = None,
    tracingConfig: Option[zio.aws.lambda.model.TracingConfig] = None,
    revisionId: Option[String] = None,
    layers: Option[Iterable[LayerVersionArn]] = None,
    fileSystemConfigs: Option[Iterable[zio.aws.lambda.model.FileSystemConfig]] =
      None,
    imageConfig: Option[zio.aws.lambda.model.ImageConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest = {
    import UpdateFunctionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        role.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.role)
      .optionallyWith(
        handler.map(value => Handler.unwrap(value): java.lang.String)
      )(_.handler)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(timeout.map(value => Timeout.unwrap(value): Integer))(
        _.timeout
      )
      .optionallyWith(
        memorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.memorySize)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(runtime.map(value => value.unwrap))(_.runtime)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(
        kmsKeyArn.map(value => KMSKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(tracingConfig.map(value => value.buildAwsValue()))(
        _.tracingConfig
      )
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            LayerVersionArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.layers)
      .optionallyWith(
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemConfigs)
      .optionallyWith(imageConfig.map(value => value.buildAwsValue()))(
        _.imageConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.UpdateFunctionConfigurationRequest.ReadOnly =
    zio.aws.lambda.model.UpdateFunctionConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateFunctionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateFunctionConfigurationRequest =
      zio.aws.lambda.model.UpdateFunctionConfigurationRequest(
        functionName,
        role.map(value => value),
        handler.map(value => value),
        description.map(value => value),
        timeout.map(value => value),
        memorySize.map(value => value),
        vpcConfig.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        runtime.map(value => value),
        deadLetterConfig.map(value => value.asEditable),
        kmsKeyArn.map(value => value),
        tracingConfig.map(value => value.asEditable),
        revisionId.map(value => value),
        layers.map(value => value),
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageConfig.map(value => value.asEditable)
      )
    def functionName: FunctionName
    def role: Option[RoleArn]
    def handler: Option[Handler]
    def description: Option[Description]
    def timeout: Option[Timeout]
    def memorySize: Option[MemorySize]
    def vpcConfig: Option[zio.aws.lambda.model.VpcConfig.ReadOnly]
    def environment: Option[zio.aws.lambda.model.Environment.ReadOnly]
    def runtime: Option[zio.aws.lambda.model.Runtime]
    def deadLetterConfig: Option[zio.aws.lambda.model.DeadLetterConfig.ReadOnly]
    def kmsKeyArn: Option[KMSKeyArn]
    def tracingConfig: Option[zio.aws.lambda.model.TracingConfig.ReadOnly]
    def revisionId: Option[String]
    def layers: Option[List[LayerVersionArn]]
    def fileSystemConfigs
        : Option[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]]
    def imageConfig: Option[zio.aws.lambda.model.ImageConfig.ReadOnly]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("role", role)
    def getHandler: ZIO[Any, AwsError, Handler] =
      AwsError.unwrapOptionField("handler", handler)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTimeout: ZIO[Any, AwsError, Timeout] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("memorySize", memorySize)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.lambda.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
    def getRuntime: ZIO[Any, AwsError, zio.aws.lambda.model.Runtime] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getDeadLetterConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DeadLetterConfig.ReadOnly] =
      AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getKmsKeyArn: ZIO[Any, AwsError, KMSKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getTracingConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.TracingConfig.ReadOnly] =
      AwsError.unwrapOptionField("tracingConfig", tracingConfig)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getLayers: ZIO[Any, AwsError, List[LayerVersionArn]] =
      AwsError.unwrapOptionField("layers", layers)
    def getFileSystemConfigs: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.FileSystemConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemConfigs", fileSystemConfigs)
    def getImageConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.ImageConfig.ReadOnly] =
      AwsError.unwrapOptionField("imageConfig", imageConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest
  ) extends zio.aws.lambda.model.UpdateFunctionConfigurationRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val role: Option[RoleArn] = scala
      .Option(impl.role())
      .map(value => zio.aws.lambda.model.primitives.RoleArn(value))
    override val handler: Option[Handler] = scala
      .Option(impl.handler())
      .map(value => zio.aws.lambda.model.primitives.Handler(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val timeout: Option[Timeout] = scala
      .Option(impl.timeout())
      .map(value => zio.aws.lambda.model.primitives.Timeout(value))
    override val memorySize: Option[MemorySize] = scala
      .Option(impl.memorySize())
      .map(value => zio.aws.lambda.model.primitives.MemorySize(value))
    override val vpcConfig: Option[zio.aws.lambda.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.lambda.model.VpcConfig.wrap(value))
    override val environment
        : Option[zio.aws.lambda.model.Environment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.lambda.model.Environment.wrap(value))
    override val runtime: Option[zio.aws.lambda.model.Runtime] = scala
      .Option(impl.runtime())
      .map(value => zio.aws.lambda.model.Runtime.wrap(value))
    override val deadLetterConfig
        : Option[zio.aws.lambda.model.DeadLetterConfig.ReadOnly] = scala
      .Option(impl.deadLetterConfig())
      .map(value => zio.aws.lambda.model.DeadLetterConfig.wrap(value))
    override val kmsKeyArn: Option[KMSKeyArn] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.lambda.model.primitives.KMSKeyArn(value))
    override val tracingConfig
        : Option[zio.aws.lambda.model.TracingConfig.ReadOnly] = scala
      .Option(impl.tracingConfig())
      .map(value => zio.aws.lambda.model.TracingConfig.wrap(value))
    override val revisionId: Option[String] =
      scala.Option(impl.revisionId()).map(value => value: String)
    override val layers: Option[List[LayerVersionArn]] = scala
      .Option(impl.layers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.LayerVersionArn(item)
        }.toList
      )
    override val fileSystemConfigs
        : Option[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]] = scala
      .Option(impl.fileSystemConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.FileSystemConfig.wrap(item)
        }.toList
      )
    override val imageConfig
        : Option[zio.aws.lambda.model.ImageConfig.ReadOnly] = scala
      .Option(impl.imageConfig())
      .map(value => zio.aws.lambda.model.ImageConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest
  ): zio.aws.lambda.model.UpdateFunctionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
