package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{
  MaximumRetryAttemptsEventSourceMapping,
  BatchSize,
  BisectBatchOnFunctionError,
  MaximumBatchingWindowInSeconds,
  ParallelizationFactor,
  FunctionName,
  Enabled,
  TumblingWindowInSeconds,
  MaximumRecordAgeInSeconds
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateEventSourceMappingRequest(
    uuid: String,
    functionName: Option[FunctionName] = None,
    enabled: Option[Enabled] = None,
    batchSize: Option[BatchSize] = None,
    filterCriteria: Option[zio.aws.lambda.model.FilterCriteria] = None,
    maximumBatchingWindowInSeconds: Option[MaximumBatchingWindowInSeconds] =
      None,
    destinationConfig: Option[zio.aws.lambda.model.DestinationConfig] = None,
    maximumRecordAgeInSeconds: Option[MaximumRecordAgeInSeconds] = None,
    bisectBatchOnFunctionError: Option[BisectBatchOnFunctionError] = None,
    maximumRetryAttempts: Option[MaximumRetryAttemptsEventSourceMapping] = None,
    parallelizationFactor: Option[ParallelizationFactor] = None,
    sourceAccessConfigurations: Option[
      Iterable[zio.aws.lambda.model.SourceAccessConfiguration]
    ] = None,
    tumblingWindowInSeconds: Option[TumblingWindowInSeconds] = None,
    functionResponseTypes: Option[
      Iterable[zio.aws.lambda.model.FunctionResponseType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest = {
    import UpdateEventSourceMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest
      .builder()
      .uuid(uuid: java.lang.String)
      .optionallyWith(
        functionName.map(value => FunctionName.unwrap(value): java.lang.String)
      )(_.functionName)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(batchSize.map(value => BatchSize.unwrap(value): Integer))(
        _.batchSize
      )
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maximumBatchingWindowInSeconds.map(value =>
          MaximumBatchingWindowInSeconds.unwrap(value): Integer
        )
      )(_.maximumBatchingWindowInSeconds)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(
        maximumRecordAgeInSeconds.map(value =>
          MaximumRecordAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumRecordAgeInSeconds)
      .optionallyWith(
        bisectBatchOnFunctionError.map(value =>
          BisectBatchOnFunctionError.unwrap(value): java.lang.Boolean
        )
      )(_.bisectBatchOnFunctionError)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttemptsEventSourceMapping.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        parallelizationFactor.map(value =>
          ParallelizationFactor.unwrap(value): Integer
        )
      )(_.parallelizationFactor)
      .optionallyWith(
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceAccessConfigurations)
      .optionallyWith(
        tumblingWindowInSeconds.map(value =>
          TumblingWindowInSeconds.unwrap(value): Integer
        )
      )(_.tumblingWindowInSeconds)
      .optionallyWith(
        functionResponseTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.functionResponseTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.UpdateEventSourceMappingRequest.ReadOnly =
    zio.aws.lambda.model.UpdateEventSourceMappingRequest.wrap(buildAwsValue())
}
object UpdateEventSourceMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateEventSourceMappingRequest =
      zio.aws.lambda.model.UpdateEventSourceMappingRequest(
        uuid,
        functionName.map(value => value),
        enabled.map(value => value),
        batchSize.map(value => value),
        filterCriteria.map(value => value.asEditable),
        maximumBatchingWindowInSeconds.map(value => value),
        destinationConfig.map(value => value.asEditable),
        maximumRecordAgeInSeconds.map(value => value),
        bisectBatchOnFunctionError.map(value => value),
        maximumRetryAttempts.map(value => value),
        parallelizationFactor.map(value => value),
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tumblingWindowInSeconds.map(value => value),
        functionResponseTypes.map(value => value)
      )
    def uuid: String
    def functionName: Option[FunctionName]
    def enabled: Option[Enabled]
    def batchSize: Option[BatchSize]
    def filterCriteria: Option[zio.aws.lambda.model.FilterCriteria.ReadOnly]
    def maximumBatchingWindowInSeconds: Option[MaximumBatchingWindowInSeconds]
    def destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly]
    def maximumRecordAgeInSeconds: Option[MaximumRecordAgeInSeconds]
    def bisectBatchOnFunctionError: Option[BisectBatchOnFunctionError]
    def maximumRetryAttempts: Option[MaximumRetryAttemptsEventSourceMapping]
    def parallelizationFactor: Option[ParallelizationFactor]
    def sourceAccessConfigurations
        : Option[List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]]
    def tumblingWindowInSeconds: Option[TumblingWindowInSeconds]
    def functionResponseTypes
        : Option[List[zio.aws.lambda.model.FunctionResponseType]]
    def getUuid: ZIO[Any, Nothing, String] = ZIO.succeed(uuid)
    def getFunctionName: ZIO[Any, AwsError, FunctionName] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getBatchSize: ZIO[Any, AwsError, BatchSize] =
      AwsError.unwrapOptionField("batchSize", batchSize)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.lambda.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaximumBatchingWindowInSeconds
        : ZIO[Any, AwsError, MaximumBatchingWindowInSeconds] =
      AwsError.unwrapOptionField(
        "maximumBatchingWindowInSeconds",
        maximumBatchingWindowInSeconds
      )
    def getDestinationConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getMaximumRecordAgeInSeconds
        : ZIO[Any, AwsError, MaximumRecordAgeInSeconds] = AwsError
      .unwrapOptionField("maximumRecordAgeInSeconds", maximumRecordAgeInSeconds)
    def getBisectBatchOnFunctionError
        : ZIO[Any, AwsError, BisectBatchOnFunctionError] =
      AwsError.unwrapOptionField(
        "bisectBatchOnFunctionError",
        bisectBatchOnFunctionError
      )
    def getMaximumRetryAttempts
        : ZIO[Any, AwsError, MaximumRetryAttemptsEventSourceMapping] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getParallelizationFactor: ZIO[Any, AwsError, ParallelizationFactor] =
      AwsError.unwrapOptionField("parallelizationFactor", parallelizationFactor)
    def getSourceAccessConfigurations: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceAccessConfigurations",
      sourceAccessConfigurations
    )
    def getTumblingWindowInSeconds
        : ZIO[Any, AwsError, TumblingWindowInSeconds] = AwsError
      .unwrapOptionField("tumblingWindowInSeconds", tumblingWindowInSeconds)
    def getFunctionResponseTypes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.FunctionResponseType]] =
      AwsError.unwrapOptionField("functionResponseTypes", functionResponseTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest
  ) extends zio.aws.lambda.model.UpdateEventSourceMappingRequest.ReadOnly {
    override val uuid: String = impl.uuid(): String
    override val functionName: Option[FunctionName] = scala
      .Option(impl.functionName())
      .map(value => zio.aws.lambda.model.primitives.FunctionName(value))
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.lambda.model.primitives.Enabled(value))
    override val batchSize: Option[BatchSize] = scala
      .Option(impl.batchSize())
      .map(value => zio.aws.lambda.model.primitives.BatchSize(value))
    override val filterCriteria
        : Option[zio.aws.lambda.model.FilterCriteria.ReadOnly] = scala
      .Option(impl.filterCriteria())
      .map(value => zio.aws.lambda.model.FilterCriteria.wrap(value))
    override val maximumBatchingWindowInSeconds
        : Option[MaximumBatchingWindowInSeconds] = scala
      .Option(impl.maximumBatchingWindowInSeconds())
      .map(value =>
        zio.aws.lambda.model.primitives.MaximumBatchingWindowInSeconds(value)
      )
    override val destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly] = scala
      .Option(impl.destinationConfig())
      .map(value => zio.aws.lambda.model.DestinationConfig.wrap(value))
    override val maximumRecordAgeInSeconds: Option[MaximumRecordAgeInSeconds] =
      scala
        .Option(impl.maximumRecordAgeInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.MaximumRecordAgeInSeconds(value)
        )
    override val bisectBatchOnFunctionError
        : Option[BisectBatchOnFunctionError] = scala
      .Option(impl.bisectBatchOnFunctionError())
      .map(value =>
        zio.aws.lambda.model.primitives.BisectBatchOnFunctionError(value)
      )
    override val maximumRetryAttempts
        : Option[MaximumRetryAttemptsEventSourceMapping] = scala
      .Option(impl.maximumRetryAttempts())
      .map(value =>
        zio.aws.lambda.model.primitives
          .MaximumRetryAttemptsEventSourceMapping(value)
      )
    override val parallelizationFactor: Option[ParallelizationFactor] = scala
      .Option(impl.parallelizationFactor())
      .map(value =>
        zio.aws.lambda.model.primitives.ParallelizationFactor(value)
      )
    override val sourceAccessConfigurations: Option[
      List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]
    ] = scala
      .Option(impl.sourceAccessConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.SourceAccessConfiguration.wrap(item)
        }.toList
      )
    override val tumblingWindowInSeconds: Option[TumblingWindowInSeconds] =
      scala
        .Option(impl.tumblingWindowInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.TumblingWindowInSeconds(value)
        )
    override val functionResponseTypes
        : Option[List[zio.aws.lambda.model.FunctionResponseType]] = scala
      .Option(impl.functionResponseTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.FunctionResponseType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest
  ): zio.aws.lambda.model.UpdateEventSourceMappingRequest.ReadOnly =
    new Wrapper(impl)
}
