package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{LicenseInfo, Description, LayerName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PublishLayerVersionRequest(
    layerName: LayerName,
    description: Option[Description] = None,
    content: zio.aws.lambda.model.LayerVersionContentInput,
    compatibleRuntimes: Option[Iterable[zio.aws.lambda.model.Runtime]] = None,
    licenseInfo: Option[LicenseInfo] = None,
    compatibleArchitectures: Option[
      Iterable[zio.aws.lambda.model.Architecture]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest = {
    import PublishLayerVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest
      .builder()
      .layerName(LayerName.unwrap(layerName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .content(content.buildAwsValue())
      .optionallyWith(
        compatibleRuntimes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibleRuntimesWithStrings)
      .optionallyWith(
        licenseInfo.map(value => LicenseInfo.unwrap(value): java.lang.String)
      )(_.licenseInfo)
      .optionallyWith(
        compatibleArchitectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibleArchitecturesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.PublishLayerVersionRequest.ReadOnly =
    zio.aws.lambda.model.PublishLayerVersionRequest.wrap(buildAwsValue())
}
object PublishLayerVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PublishLayerVersionRequest =
      zio.aws.lambda.model.PublishLayerVersionRequest(
        layerName,
        description.map(value => value),
        content.asEditable,
        compatibleRuntimes.map(value => value),
        licenseInfo.map(value => value),
        compatibleArchitectures.map(value => value)
      )
    def layerName: LayerName
    def description: Option[Description]
    def content: zio.aws.lambda.model.LayerVersionContentInput.ReadOnly
    def compatibleRuntimes: Option[List[zio.aws.lambda.model.Runtime]]
    def licenseInfo: Option[LicenseInfo]
    def compatibleArchitectures: Option[List[zio.aws.lambda.model.Architecture]]
    def getLayerName: ZIO[Any, Nothing, LayerName] = ZIO.succeed(layerName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getContent: ZIO[
      Any,
      Nothing,
      zio.aws.lambda.model.LayerVersionContentInput.ReadOnly
    ] = ZIO.succeed(content)
    def getCompatibleRuntimes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Runtime]] =
      AwsError.unwrapOptionField("compatibleRuntimes", compatibleRuntimes)
    def getLicenseInfo: ZIO[Any, AwsError, LicenseInfo] =
      AwsError.unwrapOptionField("licenseInfo", licenseInfo)
    def getCompatibleArchitectures
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Architecture]] = AwsError
      .unwrapOptionField("compatibleArchitectures", compatibleArchitectures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest
  ) extends zio.aws.lambda.model.PublishLayerVersionRequest.ReadOnly {
    override val layerName: LayerName =
      zio.aws.lambda.model.primitives.LayerName(impl.layerName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val content
        : zio.aws.lambda.model.LayerVersionContentInput.ReadOnly =
      zio.aws.lambda.model.LayerVersionContentInput.wrap(impl.content())
    override val compatibleRuntimes
        : Option[List[zio.aws.lambda.model.Runtime]] = scala
      .Option(impl.compatibleRuntimes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.Runtime.wrap(item)
        }.toList
      )
    override val licenseInfo: Option[LicenseInfo] = scala
      .Option(impl.licenseInfo())
      .map(value => zio.aws.lambda.model.primitives.LicenseInfo(value))
    override val compatibleArchitectures
        : Option[List[zio.aws.lambda.model.Architecture]] = scala
      .Option(impl.compatibleArchitectures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.Architecture.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest
  ): zio.aws.lambda.model.PublishLayerVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
