package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{
  ReservedConcurrentExecutions,
  FunctionName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutFunctionConcurrencyRequest(
    functionName: FunctionName,
    reservedConcurrentExecutions: ReservedConcurrentExecutions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest = {
    import PutFunctionConcurrencyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .reservedConcurrentExecutions(
        ReservedConcurrentExecutions.unwrap(
          reservedConcurrentExecutions
        ): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.PutFunctionConcurrencyRequest.ReadOnly =
    zio.aws.lambda.model.PutFunctionConcurrencyRequest.wrap(buildAwsValue())
}
object PutFunctionConcurrencyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PutFunctionConcurrencyRequest =
      zio.aws.lambda.model.PutFunctionConcurrencyRequest(
        functionName,
        reservedConcurrentExecutions
      )
    def functionName: FunctionName
    def reservedConcurrentExecutions: ReservedConcurrentExecutions
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getReservedConcurrentExecutions
        : ZIO[Any, Nothing, ReservedConcurrentExecutions] =
      ZIO.succeed(reservedConcurrentExecutions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest
  ) extends zio.aws.lambda.model.PutFunctionConcurrencyRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val reservedConcurrentExecutions: ReservedConcurrentExecutions =
      zio.aws.lambda.model.primitives
        .ReservedConcurrentExecutions(impl.reservedConcurrentExecutions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest
  ): zio.aws.lambda.model.PutFunctionConcurrencyRequest.ReadOnly = new Wrapper(
    impl
  )
}
