package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  EnvironmentVariableValue,
  EnvironmentVariableName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EnvironmentResponse(
    variables: Option[Map[EnvironmentVariableName, EnvironmentVariableValue]] =
      None,
    error: Option[zio.aws.lambda.model.EnvironmentError] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.EnvironmentResponse = {
    import EnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.EnvironmentResponse
      .builder()
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentVariableName
                .unwrap(key): java.lang.String) -> (EnvironmentVariableValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.EnvironmentResponse.ReadOnly =
    zio.aws.lambda.model.EnvironmentResponse.wrap(buildAwsValue())
}
object EnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.EnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.EnvironmentResponse =
      zio.aws.lambda.model.EnvironmentResponse(
        variables.map(value => value),
        error.map(value => value.asEditable)
      )
    def variables
        : Option[Map[EnvironmentVariableName, EnvironmentVariableValue]]
    def error: Option[zio.aws.lambda.model.EnvironmentError.ReadOnly]
    def getVariables: ZIO[Any, AwsError, Map[
      EnvironmentVariableName,
      EnvironmentVariableValue
    ]] = AwsError.unwrapOptionField("variables", variables)
    def getError
        : ZIO[Any, AwsError, zio.aws.lambda.model.EnvironmentError.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.EnvironmentResponse
  ) extends zio.aws.lambda.model.EnvironmentResponse.ReadOnly {
    override val variables
        : Option[Map[EnvironmentVariableName, EnvironmentVariableValue]] = scala
      .Option(impl.variables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lambda.model.primitives.EnvironmentVariableName(
              key
            ) -> zio.aws.lambda.model.primitives.EnvironmentVariableValue(value)
          })
          .toMap
      )
    override val error: Option[zio.aws.lambda.model.EnvironmentError.ReadOnly] =
      scala
        .Option(impl.error())
        .map(value => zio.aws.lambda.model.EnvironmentError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.EnvironmentResponse
  ): zio.aws.lambda.model.EnvironmentResponse.ReadOnly = new Wrapper(impl)
}
