package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.Endpoint
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SelfManagedEventSource(
    endpoints: Option[
      Map[zio.aws.lambda.model.EndPointType, Iterable[Endpoint]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.SelfManagedEventSource = {
    import SelfManagedEventSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.SelfManagedEventSource
      .builder()
      .optionallyWith(
        endpoints.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                Endpoint.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.endpointsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.SelfManagedEventSource.ReadOnly =
    zio.aws.lambda.model.SelfManagedEventSource.wrap(buildAwsValue())
}
object SelfManagedEventSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.SelfManagedEventSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.SelfManagedEventSource =
      zio.aws.lambda.model.SelfManagedEventSource(endpoints.map(value => value))
    def endpoints
        : Option[Map[zio.aws.lambda.model.EndPointType, List[Endpoint]]]
    def getEndpoints
        : ZIO[Any, AwsError, Map[zio.aws.lambda.model.EndPointType, List[
          Endpoint
        ]]] = AwsError.unwrapOptionField("endpoints", endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.SelfManagedEventSource
  ) extends zio.aws.lambda.model.SelfManagedEventSource.ReadOnly {
    override val endpoints
        : Option[Map[zio.aws.lambda.model.EndPointType, List[Endpoint]]] = scala
      .Option(impl.endpoints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lambda.model.EndPointType.wrap(key) -> value.asScala.map {
              item =>
                zio.aws.lambda.model.primitives.Endpoint(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.SelfManagedEventSource
  ): zio.aws.lambda.model.SelfManagedEventSource.ReadOnly = new Wrapper(impl)
}
