package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.MaxLayerListItems
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLayersRequest(
    compatibleRuntime: Option[zio.aws.lambda.model.Runtime] = None,
    marker: Option[String] = None,
    maxItems: Option[MaxLayerListItems] = None,
    compatibleArchitecture: Option[zio.aws.lambda.model.Architecture] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListLayersRequest = {
    import ListLayersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListLayersRequest
      .builder()
      .optionallyWith(compatibleRuntime.map(value => value.unwrap))(
        _.compatibleRuntime
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxLayerListItems.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(compatibleArchitecture.map(value => value.unwrap))(
        _.compatibleArchitecture
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListLayersRequest.ReadOnly =
    zio.aws.lambda.model.ListLayersRequest.wrap(buildAwsValue())
}
object ListLayersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListLayersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListLayersRequest =
      zio.aws.lambda.model.ListLayersRequest(
        compatibleRuntime.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value),
        compatibleArchitecture.map(value => value)
      )
    def compatibleRuntime: Option[zio.aws.lambda.model.Runtime]
    def marker: Option[String]
    def maxItems: Option[MaxLayerListItems]
    def compatibleArchitecture: Option[zio.aws.lambda.model.Architecture]
    def getCompatibleRuntime: ZIO[Any, AwsError, zio.aws.lambda.model.Runtime] =
      AwsError.unwrapOptionField("compatibleRuntime", compatibleRuntime)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxLayerListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getCompatibleArchitecture
        : ZIO[Any, AwsError, zio.aws.lambda.model.Architecture] = AwsError
      .unwrapOptionField("compatibleArchitecture", compatibleArchitecture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListLayersRequest
  ) extends zio.aws.lambda.model.ListLayersRequest.ReadOnly {
    override val compatibleRuntime: Option[zio.aws.lambda.model.Runtime] = scala
      .Option(impl.compatibleRuntime())
      .map(value => zio.aws.lambda.model.Runtime.wrap(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[MaxLayerListItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxLayerListItems(value))
    override val compatibleArchitecture
        : Option[zio.aws.lambda.model.Architecture] = scala
      .Option(impl.compatibleArchitecture())
      .map(value => zio.aws.lambda.model.Architecture.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListLayersRequest
  ): zio.aws.lambda.model.ListLayersRequest.ReadOnly = new Wrapper(impl)
}
