package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.CodeSigningConfigArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCodeSigningConfigRequest(
    codeSigningConfigArn: CodeSigningConfigArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest = {
    import DeleteCodeSigningConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest
      .builder()
      .codeSigningConfigArn(
        CodeSigningConfigArn.unwrap(codeSigningConfigArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.DeleteCodeSigningConfigRequest.ReadOnly =
    zio.aws.lambda.model.DeleteCodeSigningConfigRequest.wrap(buildAwsValue())
}
object DeleteCodeSigningConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.DeleteCodeSigningConfigRequest =
      zio.aws.lambda.model.DeleteCodeSigningConfigRequest(codeSigningConfigArn)
    def codeSigningConfigArn: CodeSigningConfigArn
    def getCodeSigningConfigArn: ZIO[Any, Nothing, CodeSigningConfigArn] =
      ZIO.succeed(codeSigningConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest
  ) extends zio.aws.lambda.model.DeleteCodeSigningConfigRequest.ReadOnly {
    override val codeSigningConfigArn: CodeSigningConfigArn =
      zio.aws.lambda.model.primitives
        .CodeSigningConfigArn(impl.codeSigningConfigArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest
  ): zio.aws.lambda.model.DeleteCodeSigningConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
