package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{SecurityGroupId, SubnetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VpcConfig(
    subnetIds: Option[Iterable[SubnetId]] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.VpcConfig = {
    import VpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.VpcConfig
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.VpcConfig.ReadOnly =
    zio.aws.lambda.model.VpcConfig.wrap(buildAwsValue())
}
object VpcConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lambda.model.VpcConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.VpcConfig =
      zio.aws.lambda.model.VpcConfig(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value)
      )
    def subnetIds: Option[List[SubnetId]]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.VpcConfig
  ) extends zio.aws.lambda.model.VpcConfig.ReadOnly {
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.SecurityGroupId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.VpcConfig
  ): zio.aws.lambda.model.VpcConfig.ReadOnly = new Wrapper(impl)
}
