package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsResponse(tags: Option[Map[TagKey, TagValue]] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListTagsResponse = {
    import ListTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListTagsResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListTagsResponse.ReadOnly =
    zio.aws.lambda.model.ListTagsResponse.wrap(buildAwsValue())
}
object ListTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListTagsResponse =
      zio.aws.lambda.model.ListTagsResponse(tags.map(value => value))
    def tags: Option[Map[TagKey, TagValue]]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListTagsResponse
  ) extends zio.aws.lambda.model.ListTagsResponse.ReadOnly {
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lambda.model.primitives
              .TagKey(key) -> zio.aws.lambda.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListTagsResponse
  ): zio.aws.lambda.model.ListTagsResponse.ReadOnly = new Wrapper(impl)
}
