package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddLayerVersionPermissionResponse(
    statement: Option[String] = None,
    revisionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse = {
    import AddLayerVersionPermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse
      .builder()
      .optionallyWith(statement.map(value => value: java.lang.String))(
        _.statement
      )
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.AddLayerVersionPermissionResponse.ReadOnly =
    zio.aws.lambda.model.AddLayerVersionPermissionResponse.wrap(buildAwsValue())
}
object AddLayerVersionPermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AddLayerVersionPermissionResponse =
      zio.aws.lambda.model.AddLayerVersionPermissionResponse(
        statement.map(value => value),
        revisionId.map(value => value)
      )
    def statement: Option[String]
    def revisionId: Option[String]
    def getStatement: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statement", statement)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse
  ) extends zio.aws.lambda.model.AddLayerVersionPermissionResponse.ReadOnly {
    override val statement: Option[String] =
      scala.Option(impl.statement()).map(value => value: String)
    override val revisionId: Option[String] =
      scala.Option(impl.revisionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse
  ): zio.aws.lambda.model.AddLayerVersionPermissionResponse.ReadOnly =
    new Wrapper(impl)
}
