package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImageConfigError(
    errorCode: Option[String] = None,
    message: Option[SensitiveString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ImageConfigError = {
    import ImageConfigError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ImageConfigError
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(
        message.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ImageConfigError.ReadOnly =
    zio.aws.lambda.model.ImageConfigError.wrap(buildAwsValue())
}
object ImageConfigError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ImageConfigError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ImageConfigError =
      zio.aws.lambda.model.ImageConfigError(
        errorCode.map(value => value),
        message.map(value => value)
      )
    def errorCode: Option[String]
    def message: Option[SensitiveString]
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ImageConfigError
  ) extends zio.aws.lambda.model.ImageConfigError.ReadOnly {
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val message: Option[SensitiveString] = scala
      .Option(impl.message())
      .map(value => zio.aws.lambda.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ImageConfigError
  ): zio.aws.lambda.model.ImageConfigError.ReadOnly = new Wrapper(impl)
}
