package zio.aws.lambda.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  MaximumEventAgeInSeconds,
  MaximumRetryAttempts,
  FunctionArn,
  Date
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FunctionEventInvokeConfig(
    lastModified: Optional[Date] = Optional.Absent,
    functionArn: Optional[FunctionArn] = Optional.Absent,
    maximumRetryAttempts: Optional[MaximumRetryAttempts] = Optional.Absent,
    maximumEventAgeInSeconds: Optional[MaximumEventAgeInSeconds] =
      Optional.Absent,
    destinationConfig: Optional[zio.aws.lambda.model.DestinationConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfig = {
    import FunctionEventInvokeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfig
      .builder()
      .optionallyWith(lastModified.map(value => Date.unwrap(value): Instant))(
        _.lastModified
      )
      .optionallyWith(
        functionArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.functionArn)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttempts.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        maximumEventAgeInSeconds.map(value =>
          MaximumEventAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumEventAgeInSeconds)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly =
    zio.aws.lambda.model.FunctionEventInvokeConfig.wrap(buildAwsValue())
}
object FunctionEventInvokeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.FunctionEventInvokeConfig =
      zio.aws.lambda.model.FunctionEventInvokeConfig(
        lastModified.map(value => value),
        functionArn.map(value => value),
        maximumRetryAttempts.map(value => value),
        maximumEventAgeInSeconds.map(value => value),
        destinationConfig.map(value => value.asEditable)
      )
    def lastModified: Optional[Date]
    def functionArn: Optional[FunctionArn]
    def maximumRetryAttempts: Optional[MaximumRetryAttempts]
    def maximumEventAgeInSeconds: Optional[MaximumEventAgeInSeconds]
    def destinationConfig
        : Optional[zio.aws.lambda.model.DestinationConfig.ReadOnly]
    def getLastModified: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getFunctionArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getMaximumRetryAttempts: ZIO[Any, AwsError, MaximumRetryAttempts] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getMaximumEventAgeInSeconds
        : ZIO[Any, AwsError, MaximumEventAgeInSeconds] = AwsError
      .unwrapOptionField("maximumEventAgeInSeconds", maximumEventAgeInSeconds)
    def getDestinationConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      AwsError.unwrapOptionField("destinationConfig", destinationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfig
  ) extends zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly {
    override val lastModified: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.lambda.model.primitives.Date(value))
    override val functionArn: Optional[FunctionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.functionArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val maximumRetryAttempts: Optional[MaximumRetryAttempts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumRetryAttempts())
        .map(value =>
          zio.aws.lambda.model.primitives.MaximumRetryAttempts(value)
        )
    override val maximumEventAgeInSeconds: Optional[MaximumEventAgeInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumEventAgeInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.MaximumEventAgeInSeconds(value)
        )
    override val destinationConfig
        : Optional[zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationConfig())
        .map(value => zio.aws.lambda.model.DestinationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfig
  ): zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly = new Wrapper(impl)
}
