package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLayersResponse(
    nextMarker: Optional[String] = Optional.Absent,
    layers: Optional[Iterable[zio.aws.lambda.model.LayersListItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListLayersResponse = {
    import ListLayersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListLayersResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.layers)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListLayersResponse.ReadOnly =
    zio.aws.lambda.model.ListLayersResponse.wrap(buildAwsValue())
}
object ListLayersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListLayersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListLayersResponse =
      zio.aws.lambda.model.ListLayersResponse(
        nextMarker.map(value => value),
        layers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[String]
    def layers: Optional[List[zio.aws.lambda.model.LayersListItem.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLayers: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.LayersListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("layers", layers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListLayersResponse
  ) extends zio.aws.lambda.model.ListLayersResponse.ReadOnly {
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
    override val layers
        : Optional[List[zio.aws.lambda.model.LayersListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.LayersListItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListLayersResponse
  ): zio.aws.lambda.model.ListLayersResponse.ReadOnly = new Wrapper(impl)
}
