package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.Blob
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InvokeResponseStreamUpdate(
    payload: Optional[Blob] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.InvokeResponseStreamUpdate = {
    import InvokeResponseStreamUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.InvokeResponseStreamUpdate
      .builder()
      .optionallyWith(
        payload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.payload)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.InvokeResponseStreamUpdate.ReadOnly =
    zio.aws.lambda.model.InvokeResponseStreamUpdate.wrap(buildAwsValue())
}
object InvokeResponseStreamUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.InvokeResponseStreamUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.InvokeResponseStreamUpdate =
      zio.aws.lambda.model
        .InvokeResponseStreamUpdate(payload.map(value => value))
    def payload: Optional[Blob]
    def getPayload: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("payload", payload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.InvokeResponseStreamUpdate
  ) extends zio.aws.lambda.model.InvokeResponseStreamUpdate.ReadOnly {
    override val payload: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.payload())
      .map(value =>
        zio.aws.lambda.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.InvokeResponseStreamUpdate
  ): zio.aws.lambda.model.InvokeResponseStreamUpdate.ReadOnly = new Wrapper(
    impl
  )
}
