package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait ResponseStreamingInvocationType {
  def unwrap: software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType
}
object ResponseStreamingInvocationType {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType
  ): zio.aws.lambda.model.ResponseStreamingInvocationType = value match {
    case software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType.REQUEST_RESPONSE =>
      val r = RequestResponse
      r
    case software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType.DRY_RUN =>
      val r = DryRun
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.ResponseStreamingInvocationType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType =
      software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object RequestResponse
      extends zio.aws.lambda.model.ResponseStreamingInvocationType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType =
      software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType.REQUEST_RESPONSE
  }
  case object DryRun
      extends zio.aws.lambda.model.ResponseStreamingInvocationType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType =
      software.amazon.awssdk.services.lambda.model.ResponseStreamingInvocationType.DRY_RUN
  }
}
