package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Timestamp, FunctionArn, FunctionUrl}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFunctionUrlConfigResponse(
    functionUrl: FunctionUrl,
    functionArn: FunctionArn,
    authType: zio.aws.lambda.model.FunctionUrlAuthType,
    cors: Optional[zio.aws.lambda.model.Cors] = Optional.Absent,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    invokeMode: Optional[zio.aws.lambda.model.InvokeMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigResponse = {
    import UpdateFunctionUrlConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigResponse
      .builder()
      .functionUrl(FunctionUrl.unwrap(functionUrl): java.lang.String)
      .functionArn(FunctionArn.unwrap(functionArn): java.lang.String)
      .authType(authType.unwrap)
      .optionallyWith(cors.map(value => value.buildAwsValue()))(_.cors)
      .creationTime(Timestamp.unwrap(creationTime): java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): java.lang.String)
      .optionallyWith(invokeMode.map(value => value.unwrap))(_.invokeMode)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.UpdateFunctionUrlConfigResponse.ReadOnly =
    zio.aws.lambda.model.UpdateFunctionUrlConfigResponse.wrap(buildAwsValue())
}
object UpdateFunctionUrlConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateFunctionUrlConfigResponse =
      zio.aws.lambda.model.UpdateFunctionUrlConfigResponse(
        functionUrl,
        functionArn,
        authType,
        cors.map(value => value.asEditable),
        creationTime,
        lastModifiedTime,
        invokeMode.map(value => value)
      )
    def functionUrl: FunctionUrl
    def functionArn: FunctionArn
    def authType: zio.aws.lambda.model.FunctionUrlAuthType
    def cors: Optional[zio.aws.lambda.model.Cors.ReadOnly]
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def invokeMode: Optional[zio.aws.lambda.model.InvokeMode]
    def getFunctionUrl: ZIO[Any, Nothing, FunctionUrl] =
      ZIO.succeed(functionUrl)
    def getFunctionArn: ZIO[Any, Nothing, FunctionArn] =
      ZIO.succeed(functionArn)
    def getAuthType
        : ZIO[Any, Nothing, zio.aws.lambda.model.FunctionUrlAuthType] =
      ZIO.succeed(authType)
    def getCors: ZIO[Any, AwsError, zio.aws.lambda.model.Cors.ReadOnly] =
      AwsError.unwrapOptionField("cors", cors)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getInvokeMode: ZIO[Any, AwsError, zio.aws.lambda.model.InvokeMode] =
      AwsError.unwrapOptionField("invokeMode", invokeMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigResponse
  ) extends zio.aws.lambda.model.UpdateFunctionUrlConfigResponse.ReadOnly {
    override val functionUrl: FunctionUrl =
      zio.aws.lambda.model.primitives.FunctionUrl(impl.functionUrl())
    override val functionArn: FunctionArn =
      zio.aws.lambda.model.primitives.FunctionArn(impl.functionArn())
    override val authType: zio.aws.lambda.model.FunctionUrlAuthType =
      zio.aws.lambda.model.FunctionUrlAuthType.wrap(impl.authType())
    override val cors: Optional[zio.aws.lambda.model.Cors.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cors())
        .map(value => zio.aws.lambda.model.Cors.wrap(value))
    override val creationTime: Timestamp =
      zio.aws.lambda.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.lambda.model.primitives.Timestamp(impl.lastModifiedTime())
    override val invokeMode: Optional[zio.aws.lambda.model.InvokeMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invokeMode())
        .map(value => zio.aws.lambda.model.InvokeMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigResponse
  ): zio.aws.lambda.model.UpdateFunctionUrlConfigResponse.ReadOnly =
    new Wrapper(impl)
}
