package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{MaxItems, FunctionName}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFunctionUrlConfigsRequest(
    functionName: FunctionName,
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest = {
    import ListFunctionUrlConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListFunctionUrlConfigsRequest.ReadOnly =
    zio.aws.lambda.model.ListFunctionUrlConfigsRequest.wrap(buildAwsValue())
}
object ListFunctionUrlConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListFunctionUrlConfigsRequest =
      zio.aws.lambda.model.ListFunctionUrlConfigsRequest(
        functionName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def functionName: FunctionName
    def marker: Optional[String]
    def maxItems: Optional[MaxItems]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest
  ) extends zio.aws.lambda.model.ListFunctionUrlConfigsRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest
  ): zio.aws.lambda.model.ListFunctionUrlConfigsRequest.ReadOnly = new Wrapper(
    impl
  )
}
