package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait SnapStartApplyOn {
  def unwrap: software.amazon.awssdk.services.lambda.model.SnapStartApplyOn
}
object SnapStartApplyOn {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.SnapStartApplyOn
  ): zio.aws.lambda.model.SnapStartApplyOn = value match {
    case software.amazon.awssdk.services.lambda.model.SnapStartApplyOn.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.SnapStartApplyOn.PUBLISHED_VERSIONS =>
      val r = PublishedVersions
      r
    case software.amazon.awssdk.services.lambda.model.SnapStartApplyOn.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.SnapStartApplyOn {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SnapStartApplyOn =
      software.amazon.awssdk.services.lambda.model.SnapStartApplyOn.UNKNOWN_TO_SDK_VERSION
  }
  case object PublishedVersions extends zio.aws.lambda.model.SnapStartApplyOn {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SnapStartApplyOn =
      software.amazon.awssdk.services.lambda.model.SnapStartApplyOn.PUBLISHED_VERSIONS
  }
  case object None extends zio.aws.lambda.model.SnapStartApplyOn {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SnapStartApplyOn =
      software.amazon.awssdk.services.lambda.model.SnapStartApplyOn.NONE
  }
}
