package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  RuntimeVersionArn,
  Qualifier,
  FunctionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutRuntimeManagementConfigRequest(
    functionName: FunctionName,
    qualifier: Optional[Qualifier] = Optional.Absent,
    updateRuntimeOn: zio.aws.lambda.model.UpdateRuntimeOn,
    runtimeVersionArn: Optional[RuntimeVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigRequest = {
    import PutRuntimeManagementConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .updateRuntimeOn(updateRuntimeOn.unwrap)
      .optionallyWith(
        runtimeVersionArn.map(value =>
          RuntimeVersionArn.unwrap(value): java.lang.String
        )
      )(_.runtimeVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.PutRuntimeManagementConfigRequest.ReadOnly =
    zio.aws.lambda.model.PutRuntimeManagementConfigRequest.wrap(buildAwsValue())
}
object PutRuntimeManagementConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PutRuntimeManagementConfigRequest =
      zio.aws.lambda.model.PutRuntimeManagementConfigRequest(
        functionName,
        qualifier.map(value => value),
        updateRuntimeOn,
        runtimeVersionArn.map(value => value)
      )
    def functionName: FunctionName
    def qualifier: Optional[Qualifier]
    def updateRuntimeOn: zio.aws.lambda.model.UpdateRuntimeOn
    def runtimeVersionArn: Optional[RuntimeVersionArn]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
    def getUpdateRuntimeOn
        : ZIO[Any, Nothing, zio.aws.lambda.model.UpdateRuntimeOn] =
      ZIO.succeed(updateRuntimeOn)
    def getRuntimeVersionArn: ZIO[Any, AwsError, RuntimeVersionArn] =
      AwsError.unwrapOptionField("runtimeVersionArn", runtimeVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigRequest
  ) extends zio.aws.lambda.model.PutRuntimeManagementConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Optional[Qualifier] = zio.aws.core.internal
      .optionalFromNullable(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
    override val updateRuntimeOn: zio.aws.lambda.model.UpdateRuntimeOn =
      zio.aws.lambda.model.UpdateRuntimeOn.wrap(impl.updateRuntimeOn())
    override val runtimeVersionArn: Optional[RuntimeVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeVersionArn())
        .map(value => zio.aws.lambda.model.primitives.RuntimeVersionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigRequest
  ): zio.aws.lambda.model.PutRuntimeManagementConfigRequest.ReadOnly =
    new Wrapper(impl)
}
