package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait InvokeMode {
  def unwrap: software.amazon.awssdk.services.lambda.model.InvokeMode
}
object InvokeMode {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.InvokeMode
  ): zio.aws.lambda.model.InvokeMode = value match {
    case software.amazon.awssdk.services.lambda.model.InvokeMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.InvokeMode.BUFFERED =>
      val r = BUFFERED
      r
    case software.amazon.awssdk.services.lambda.model.InvokeMode.RESPONSE_STREAM =>
      val r = RESPONSE_STREAM
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.InvokeMode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.InvokeMode =
      software.amazon.awssdk.services.lambda.model.InvokeMode.UNKNOWN_TO_SDK_VERSION
  }
  case object BUFFERED extends zio.aws.lambda.model.InvokeMode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.InvokeMode =
      software.amazon.awssdk.services.lambda.model.InvokeMode.BUFFERED
  }
  case object RESPONSE_STREAM extends zio.aws.lambda.model.InvokeMode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.InvokeMode =
      software.amazon.awssdk.services.lambda.model.InvokeMode.RESPONSE_STREAM
  }
}
