package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  Description,
  Version,
  Alias,
  FunctionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAliasRequest(
    functionName: FunctionName,
    name: Alias,
    functionVersion: Optional[Version] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    routingConfig: Optional[zio.aws.lambda.model.AliasRoutingConfiguration] =
      Optional.Absent,
    revisionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateAliasRequest = {
    import UpdateAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateAliasRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .name(Alias.unwrap(name): java.lang.String)
      .optionallyWith(
        functionVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.functionVersion)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(routingConfig.map(value => value.buildAwsValue()))(
        _.routingConfig
      )
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.UpdateAliasRequest.ReadOnly =
    zio.aws.lambda.model.UpdateAliasRequest.wrap(buildAwsValue())
}
object UpdateAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateAliasRequest =
      zio.aws.lambda.model.UpdateAliasRequest(
        functionName,
        name,
        functionVersion.map(value => value),
        description.map(value => value),
        routingConfig.map(value => value.asEditable),
        revisionId.map(value => value)
      )
    def functionName: FunctionName
    def name: Alias
    def functionVersion: Optional[Version]
    def description: Optional[Description]
    def routingConfig
        : Optional[zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly]
    def revisionId: Optional[String]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getName: ZIO[Any, Nothing, Alias] = ZIO.succeed(name)
    def getFunctionVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("functionVersion", functionVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("routingConfig", routingConfig)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateAliasRequest
  ) extends zio.aws.lambda.model.UpdateAliasRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val name: Alias =
      zio.aws.lambda.model.primitives.Alias(impl.name())
    override val functionVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.functionVersion())
      .map(value => zio.aws.lambda.model.primitives.Version(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val routingConfig
        : Optional[zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingConfig())
        .map(value =>
          zio.aws.lambda.model.AliasRoutingConfiguration.wrap(value)
        )
    override val revisionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateAliasRequest
  ): zio.aws.lambda.model.UpdateAliasRequest.ReadOnly = new Wrapper(impl)
}
