package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait FullDocument {
  def unwrap: software.amazon.awssdk.services.lambda.model.FullDocument
}
object FullDocument {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.FullDocument
  ): zio.aws.lambda.model.FullDocument = value match {
    case software.amazon.awssdk.services.lambda.model.FullDocument.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.FullDocument.UPDATE_LOOKUP =>
      val r = UpdateLookup
      r
    case software.amazon.awssdk.services.lambda.model.FullDocument.DEFAULT =>
      val r = Default
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.FullDocument {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FullDocument =
      software.amazon.awssdk.services.lambda.model.FullDocument.UNKNOWN_TO_SDK_VERSION
  }
  case object UpdateLookup extends zio.aws.lambda.model.FullDocument {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FullDocument =
      software.amazon.awssdk.services.lambda.model.FullDocument.UPDATE_LOOKUP
  }
  case object Default extends zio.aws.lambda.model.FullDocument {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FullDocument =
      software.amazon.awssdk.services.lambda.model.FullDocument.DEFAULT
  }
}
