package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.MaximumConcurrency
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ScalingConfig(
    maximumConcurrency: Optional[MaximumConcurrency] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ScalingConfig = {
    import ScalingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ScalingConfig
      .builder()
      .optionallyWith(
        maximumConcurrency.map(value =>
          MaximumConcurrency.unwrap(value): Integer
        )
      )(_.maximumConcurrency)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ScalingConfig.ReadOnly =
    zio.aws.lambda.model.ScalingConfig.wrap(buildAwsValue())
}
object ScalingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ScalingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ScalingConfig =
      zio.aws.lambda.model.ScalingConfig(maximumConcurrency.map(value => value))
    def maximumConcurrency: Optional[MaximumConcurrency]
    def getMaximumConcurrency: ZIO[Any, AwsError, MaximumConcurrency] =
      AwsError.unwrapOptionField("maximumConcurrency", maximumConcurrency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ScalingConfig
  ) extends zio.aws.lambda.model.ScalingConfig.ReadOnly {
    override val maximumConcurrency: Optional[MaximumConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumConcurrency())
        .map(value => zio.aws.lambda.model.primitives.MaximumConcurrency(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ScalingConfig
  ): zio.aws.lambda.model.ScalingConfig.ReadOnly = new Wrapper(impl)
}
