package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait LastUpdateStatus {
  def unwrap: software.amazon.awssdk.services.lambda.model.LastUpdateStatus
}
object LastUpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.LastUpdateStatus
  ): zio.aws.lambda.model.LastUpdateStatus = value match {
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatus.SUCCESSFUL =>
      val r = Successful
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatus.IN_PROGRESS =>
      val r = InProgress
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.LastUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatus =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Successful extends zio.aws.lambda.model.LastUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatus =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatus.SUCCESSFUL
  }
  case object Failed extends zio.aws.lambda.model.LastUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatus =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatus.FAILED
  }
  case object InProgress extends zio.aws.lambda.model.LastUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatus =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatus.IN_PROGRESS
  }
}
