package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{MaxListItems, Version, FunctionName}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAliasesRequest(
    functionName: FunctionName,
    functionVersion: Optional[Version] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[MaxListItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListAliasesRequest = {
    import ListAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListAliasesRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        functionVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.functionVersion)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxListItems.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListAliasesRequest.ReadOnly =
    zio.aws.lambda.model.ListAliasesRequest.wrap(buildAwsValue())
}
object ListAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListAliasesRequest =
      zio.aws.lambda.model.ListAliasesRequest(
        functionName,
        functionVersion.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def functionName: FunctionName
    def functionVersion: Optional[Version]
    def marker: Optional[String]
    def maxItems: Optional[MaxListItems]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getFunctionVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("functionVersion", functionVersion)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListAliasesRequest
  ) extends zio.aws.lambda.model.ListAliasesRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val functionVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.functionVersion())
      .map(value => zio.aws.lambda.model.primitives.Version(value))
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[MaxListItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxListItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListAliasesRequest
  ): zio.aws.lambda.model.ListAliasesRequest.ReadOnly = new Wrapper(impl)
}
