package zio.aws.lambda
import zio.aws.lambda.model.primitives.SubnetId.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.lambda.model.primitives.{
  SubnetId,
  SecurityGroupId,
  Method,
  Queue,
  TagValue,
  EnvironmentVariableName,
  Arn,
  LayerVersionArn,
  Weight,
  FunctionArn,
  Origin,
  Topic,
  Endpoint,
  EnvironmentVariableValue,
  AdditionalVersion,
  Header,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Action extends Subtype[String]
    type Action = zio.aws.lambda.model.primitives.Action.Type
    object AdditionalVersion extends Subtype[String]
    type AdditionalVersion =
      zio.aws.lambda.model.primitives.AdditionalVersion.Type
    object Alias extends Subtype[String]
    type Alias = zio.aws.lambda.model.primitives.Alias.Type
    object AllowCredentials extends Subtype[Boolean]
    type AllowCredentials =
      zio.aws.lambda.model.primitives.AllowCredentials.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.lambda.model.primitives.Arn.Type
    object BatchSize extends Subtype[Int]
    type BatchSize = zio.aws.lambda.model.primitives.BatchSize.Type
    object BisectBatchOnFunctionError extends Subtype[Boolean]
    type BisectBatchOnFunctionError =
      zio.aws.lambda.model.primitives.BisectBatchOnFunctionError.Type
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.lambda.model.primitives.Blob.Type
    object CodeSigningConfigArn extends Subtype[String]
    type CodeSigningConfigArn =
      zio.aws.lambda.model.primitives.CodeSigningConfigArn.Type
    object CodeSigningConfigId extends Subtype[String]
    type CodeSigningConfigId =
      zio.aws.lambda.model.primitives.CodeSigningConfigId.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.lambda.model.primitives.Date.Type
    object Description extends Subtype[String]
    type Description = zio.aws.lambda.model.primitives.Description.Type
    object DestinationArn extends Subtype[String]
    type DestinationArn = zio.aws.lambda.model.primitives.DestinationArn.Type
    object Enabled extends Subtype[Boolean]
    type Enabled = zio.aws.lambda.model.primitives.Enabled.Type
    object Endpoint extends Subtype[String]
    type Endpoint = zio.aws.lambda.model.primitives.Endpoint.Type
    object EnvironmentVariableName extends Subtype[String]
    type EnvironmentVariableName =
      zio.aws.lambda.model.primitives.EnvironmentVariableName.Type
    object EnvironmentVariableValue extends Subtype[String]
    type EnvironmentVariableValue =
      zio.aws.lambda.model.primitives.EnvironmentVariableValue.Type
    object EphemeralStorageSize extends Subtype[Int]
    type EphemeralStorageSize =
      zio.aws.lambda.model.primitives.EphemeralStorageSize.Type
    object EventSourceToken extends Subtype[String]
    type EventSourceToken =
      zio.aws.lambda.model.primitives.EventSourceToken.Type
    object FileSystemArn extends Subtype[String]
    type FileSystemArn = zio.aws.lambda.model.primitives.FileSystemArn.Type
    object FunctionArn extends Subtype[String]
    type FunctionArn = zio.aws.lambda.model.primitives.FunctionArn.Type
    object FunctionName extends Subtype[String]
    type FunctionName = zio.aws.lambda.model.primitives.FunctionName.Type
    object FunctionUrl extends Subtype[String]
    type FunctionUrl = zio.aws.lambda.model.primitives.FunctionUrl.Type
    object FunctionUrlQualifier extends Subtype[String]
    type FunctionUrlQualifier =
      zio.aws.lambda.model.primitives.FunctionUrlQualifier.Type
    object Handler extends Subtype[String]
    type Handler = zio.aws.lambda.model.primitives.Handler.Type
    object Header extends Subtype[String]
    type Header = zio.aws.lambda.model.primitives.Header.Type
    type Integer = Int
    object KMSKeyArn extends Subtype[String]
    type KMSKeyArn = zio.aws.lambda.model.primitives.KMSKeyArn.Type
    object LastUpdateStatusReason extends Subtype[String]
    type LastUpdateStatusReason =
      zio.aws.lambda.model.primitives.LastUpdateStatusReason.Type
    object LayerArn extends Subtype[String]
    type LayerArn = zio.aws.lambda.model.primitives.LayerArn.Type
    object LayerName extends Subtype[String]
    type LayerName = zio.aws.lambda.model.primitives.LayerName.Type
    object LayerPermissionAllowedAction extends Subtype[String]
    type LayerPermissionAllowedAction =
      zio.aws.lambda.model.primitives.LayerPermissionAllowedAction.Type
    object LayerPermissionAllowedPrincipal extends Subtype[String]
    type LayerPermissionAllowedPrincipal =
      zio.aws.lambda.model.primitives.LayerPermissionAllowedPrincipal.Type
    object LayerVersionArn extends Subtype[String]
    type LayerVersionArn = zio.aws.lambda.model.primitives.LayerVersionArn.Type
    object LayerVersionNumber extends Subtype[Long]
    type LayerVersionNumber =
      zio.aws.lambda.model.primitives.LayerVersionNumber.Type
    object LicenseInfo extends Subtype[String]
    type LicenseInfo = zio.aws.lambda.model.primitives.LicenseInfo.Type
    object LocalMountPath extends Subtype[String]
    type LocalMountPath = zio.aws.lambda.model.primitives.LocalMountPath.Type
    object MasterRegion extends Subtype[String]
    type MasterRegion = zio.aws.lambda.model.primitives.MasterRegion.Type
    object MaxAge extends Subtype[Int]
    type MaxAge = zio.aws.lambda.model.primitives.MaxAge.Type
    object MaxFunctionEventInvokeConfigListItems extends Subtype[Int]
    type MaxFunctionEventInvokeConfigListItems =
      zio.aws.lambda.model.primitives.MaxFunctionEventInvokeConfigListItems.Type
    object MaxItems extends Subtype[Int]
    type MaxItems = zio.aws.lambda.model.primitives.MaxItems.Type
    object MaxLayerListItems extends Subtype[Int]
    type MaxLayerListItems =
      zio.aws.lambda.model.primitives.MaxLayerListItems.Type
    object MaxListItems extends Subtype[Int]
    type MaxListItems = zio.aws.lambda.model.primitives.MaxListItems.Type
    object MaxProvisionedConcurrencyConfigListItems extends Subtype[Int]
    type MaxProvisionedConcurrencyConfigListItems =
      zio.aws.lambda.model.primitives.MaxProvisionedConcurrencyConfigListItems.Type
    object MaximumBatchingWindowInSeconds extends Subtype[Int]
    type MaximumBatchingWindowInSeconds =
      zio.aws.lambda.model.primitives.MaximumBatchingWindowInSeconds.Type
    object MaximumConcurrency extends Subtype[Int]
    type MaximumConcurrency =
      zio.aws.lambda.model.primitives.MaximumConcurrency.Type
    object MaximumEventAgeInSeconds extends Subtype[Int]
    type MaximumEventAgeInSeconds =
      zio.aws.lambda.model.primitives.MaximumEventAgeInSeconds.Type
    object MaximumRecordAgeInSeconds extends Subtype[Int]
    type MaximumRecordAgeInSeconds =
      zio.aws.lambda.model.primitives.MaximumRecordAgeInSeconds.Type
    object MaximumRetryAttempts extends Subtype[Int]
    type MaximumRetryAttempts =
      zio.aws.lambda.model.primitives.MaximumRetryAttempts.Type
    object MaximumRetryAttemptsEventSourceMapping extends Subtype[Int]
    type MaximumRetryAttemptsEventSourceMapping =
      zio.aws.lambda.model.primitives.MaximumRetryAttemptsEventSourceMapping.Type
    object MemorySize extends Subtype[Int]
    type MemorySize = zio.aws.lambda.model.primitives.MemorySize.Type
    object Method extends Subtype[String]
    type Method = zio.aws.lambda.model.primitives.Method.Type
    object NameSpacedFunctionArn extends Subtype[String]
    type NameSpacedFunctionArn =
      zio.aws.lambda.model.primitives.NameSpacedFunctionArn.Type
    object NamespacedFunctionName extends Subtype[String]
    type NamespacedFunctionName =
      zio.aws.lambda.model.primitives.NamespacedFunctionName.Type
    object NamespacedStatementId extends Subtype[String]
    type NamespacedStatementId =
      zio.aws.lambda.model.primitives.NamespacedStatementId.Type
    object NonNegativeInteger extends Subtype[Int]
    type NonNegativeInteger =
      zio.aws.lambda.model.primitives.NonNegativeInteger.Type
    object OrganizationId extends Subtype[String]
    type OrganizationId = zio.aws.lambda.model.primitives.OrganizationId.Type
    object Origin extends Subtype[String]
    type Origin = zio.aws.lambda.model.primitives.Origin.Type
    object ParallelizationFactor extends Subtype[Int]
    type ParallelizationFactor =
      zio.aws.lambda.model.primitives.ParallelizationFactor.Type
    object Pattern extends Subtype[String]
    type Pattern = zio.aws.lambda.model.primitives.Pattern.Type
    object PositiveInteger extends Subtype[Int]
    type PositiveInteger = zio.aws.lambda.model.primitives.PositiveInteger.Type
    object Principal extends Subtype[String]
    type Principal = zio.aws.lambda.model.primitives.Principal.Type
    object PrincipalOrgID extends Subtype[String]
    type PrincipalOrgID = zio.aws.lambda.model.primitives.PrincipalOrgID.Type
    object Qualifier extends Subtype[String]
    type Qualifier = zio.aws.lambda.model.primitives.Qualifier.Type
    object Queue extends Subtype[String]
    type Queue = zio.aws.lambda.model.primitives.Queue.Type
    object ReservedConcurrentExecutions extends Subtype[Int]
    type ReservedConcurrentExecutions =
      zio.aws.lambda.model.primitives.ReservedConcurrentExecutions.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.lambda.model.primitives.ResourceArn.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.lambda.model.primitives.RoleArn.Type
    object RuntimeVersionArn extends Subtype[String]
    type RuntimeVersionArn =
      zio.aws.lambda.model.primitives.RuntimeVersionArn.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.lambda.model.primitives.S3Bucket.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.lambda.model.primitives.S3Key.Type
    object S3ObjectVersion extends Subtype[String]
    type S3ObjectVersion = zio.aws.lambda.model.primitives.S3ObjectVersion.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId = zio.aws.lambda.model.primitives.SecurityGroupId.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString = zio.aws.lambda.model.primitives.SensitiveString.Type
    object SourceOwner extends Subtype[String]
    type SourceOwner = zio.aws.lambda.model.primitives.SourceOwner.Type
    object StateReason extends Subtype[String]
    type StateReason = zio.aws.lambda.model.primitives.StateReason.Type
    object StatementId extends Subtype[String]
    type StatementId = zio.aws.lambda.model.primitives.StatementId.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.lambda.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.lambda.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.lambda.model.primitives.TagValue.Type
    object Timeout extends Subtype[Int]
    type Timeout = zio.aws.lambda.model.primitives.Timeout.Type
    object Timestamp extends Subtype[String]
    type Timestamp = zio.aws.lambda.model.primitives.Timestamp.Type
    object Topic extends Subtype[String]
    type Topic = zio.aws.lambda.model.primitives.Topic.Type
    object TumblingWindowInSeconds extends Subtype[Int]
    type TumblingWindowInSeconds =
      zio.aws.lambda.model.primitives.TumblingWindowInSeconds.Type
    object URI extends Subtype[String]
    type URI = zio.aws.lambda.model.primitives.URI.Type
    object UnreservedConcurrentExecutions extends Subtype[Int]
    type UnreservedConcurrentExecutions =
      zio.aws.lambda.model.primitives.UnreservedConcurrentExecutions.Type
    object Version extends Subtype[String]
    type Version = zio.aws.lambda.model.primitives.Version.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.lambda.model.primitives.VpcId.Type
    object Weight extends Subtype[Double]
    type Weight = zio.aws.lambda.model.primitives.Weight.Type
    object WorkingDirectory extends Subtype[String]
    type WorkingDirectory =
      zio.aws.lambda.model.primitives.WorkingDirectory.Type
  }
  type AdditionalVersionWeights = Map[AdditionalVersion, Weight]
  type AliasList = List[zio.aws.lambda.model.AliasConfiguration]
  type AllowMethodsList = List[Method]
  type AllowOriginsList = List[Origin]
  type ArchitecturesList = List[zio.aws.lambda.model.Architecture]
  type CodeSigningConfigList = List[zio.aws.lambda.model.CodeSigningConfig]
  type CompatibleArchitectures = List[zio.aws.lambda.model.Architecture]
  type CompatibleRuntimes = List[zio.aws.lambda.model.Runtime]
  type EndpointLists = List[Endpoint]
  type Endpoints = Map[zio.aws.lambda.model.EndPointType, Iterable[Endpoint]]
  type EnvironmentVariables =
    Map[EnvironmentVariableName, EnvironmentVariableValue]
  type EventSourceMappingsList =
    List[zio.aws.lambda.model.EventSourceMappingConfiguration]
  type FileSystemConfigList = List[zio.aws.lambda.model.FileSystemConfig]
  type FilterList = List[zio.aws.lambda.model.Filter]
  type FunctionArnList = List[FunctionArn]
  type FunctionEventInvokeConfigList =
    List[zio.aws.lambda.model.FunctionEventInvokeConfig]
  type FunctionList = List[zio.aws.lambda.model.FunctionConfiguration]
  type FunctionResponseTypeList =
    List[zio.aws.lambda.model.FunctionResponseType]
  type FunctionUrlConfigList = List[zio.aws.lambda.model.FunctionUrlConfig]
  type HeadersList = List[Header]
  type LayerList = List[LayerVersionArn]
  type LayerVersionsList = List[zio.aws.lambda.model.LayerVersionsListItem]
  type LayersList = List[zio.aws.lambda.model.LayersListItem]
  type LayersReferenceList = List[zio.aws.lambda.model.Layer]
  type ProvisionedConcurrencyConfigList =
    List[zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem]
  type Queues = List[Queue]
  type SecurityGroupIds = List[SecurityGroupId]
  type SigningProfileVersionArns = List[Arn]
  type SourceAccessConfigurations =
    List[zio.aws.lambda.model.SourceAccessConfiguration]
  type StringList = List[String]
  type SubnetIds = List[SubnetId]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
  type Topics = List[Topic]
}
